/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.tools.math.Averagable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeight
extends Averagable
implements Comparable<AttributeWeight> {
    private static final long serialVersionUID = 4459877599722270416L;
    private String name;
    private double weight;
    private int counter = 1;
    private AttributeWeights weights;

    public AttributeWeight(AttributeWeights weights, String name, double weight) {
        this.weights = weights;
        this.name = name;
        this.weight = weight;
    }

    public AttributeWeight(AttributeWeight attWeight) {
        super(attWeight);
        this.weights = attWeight.weights;
        this.name = attWeight.name;
        this.weight = attWeight.weight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getWeight() {
        return this.weight / (double)this.counter;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getMikroVariance() {
        return this.getMakroVariance();
    }

    @Override
    public double getMikroAverage() {
        return this.getWeight() / (double)this.counter;
    }

    @Override
    public int compareTo(AttributeWeight o) {
        double w1 = this.weight;
        double w2 = o.weight;
        assert (this.weights == o.weights);
        if (this.weights.getWeightType() == 1) {
            w1 = Math.abs(w1);
            w2 = Math.abs(w2);
        }
        return Double.compare(w1, w2) * this.weights.getSortingType();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AttributeWeight)) {
            return false;
        }
        AttributeWeight w = (AttributeWeight)o;
        return this.name.equals(w.name) && this.weight == w.weight;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.weight);
        return this.name.hashCode() ^ (int)(bits ^ bits >>> 32);
    }

    @Override
    public void buildSingleAverage(Averagable avg) {
        AttributeWeight other = (AttributeWeight)avg;
        this.weight += other.weight;
        this.counter += other.counter;
    }
}

