/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.SparseDataRow;
import com.rapidminer.operator.UserError;
import java.util.Arrays;

public class FastExample2SparseTransform {
    private int[] mapping;
    private Attribute[] attributes;
    private int[] allIndices;

    public FastExample2SparseTransform(ExampleSet es) throws UserError {
        this.mapping = new int[es.getExampleTable().getNumberOfAttributes()];
        int i = 0;
        while (i < this.mapping.length) {
            this.mapping[i] = -1;
            ++i;
        }
        int pos = 0;
        this.attributes = new Attribute[es.getAttributes().size()];
        this.allIndices = new int[es.getAttributes().size()];
        for (Attribute attribute : es.getAttributes()) {
            int tableIndex = attribute.getTableIndex();
            if (tableIndex != -2) {
                this.mapping[attribute.getTableIndex()] = pos;
                this.attributes[pos] = attribute;
                this.allIndices[pos] = pos;
                ++pos;
                continue;
            }
            throw new UserError(null, 140);
        }
        for (Example e : es) {
            e.getDataRow().trim();
        }
    }

    public int[] getNonDefaultAttributeIndices(Example example) {
        int numberNonDefaultAttributes = 0;
        DataRow data = example.getDataRow();
        if (data instanceof SparseDataRow) {
            int[] nonDefaultInd = ((SparseDataRow)((Object)data)).getNonDefaultIndices();
            int[] tempArray = new int[nonDefaultInd.length];
            int i = 0;
            while (i < nonDefaultInd.length) {
                int nextPos = this.mapping[nonDefaultInd[i]];
                if (nextPos != -1) {
                    tempArray[numberNonDefaultAttributes++] = nextPos;
                }
                ++i;
            }
            int[] finalArray = new int[numberNonDefaultAttributes];
            System.arraycopy(tempArray, 0, finalArray, 0, numberNonDefaultAttributes);
            Arrays.sort(finalArray);
            return finalArray;
        }
        return this.allIndices;
    }

    public double[] getNonDefaultAttributeValues(Example example) {
        return this.getNonDefaultAttributeValues(example, this.getNonDefaultAttributeIndices(example));
    }

    public double[] getNonDefaultAttributeValues(Example example, int[] nonDefaultIndices) {
        double[] result = new double[nonDefaultIndices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = example.getValue(this.attributes[nonDefaultIndices[i]]);
            ++i;
        }
        return result;
    }
}

