/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeValueFilterSingleCondition;
import com.rapidminer.example.set.Condition;
import java.util.LinkedList;
import java.util.List;

public class AttributeValueFilter
implements Condition {
    private static final long serialVersionUID = 6977275837081172924L;
    private static final int AND = 0;
    private static final int OR = 1;
    private List<AttributeValueFilterSingleCondition> conditions = new LinkedList<AttributeValueFilterSingleCondition>();
    private int combinationMode = 0;

    public AttributeValueFilter(Attribute attribute, int comparisonType, String value) {
        this.addCondition(attribute, comparisonType, value);
    }

    public AttributeValueFilter(ExampleSet exampleSet, String parameterString) {
        if (parameterString == null || parameterString.length() == 0) {
            throw new IllegalArgumentException("Parameter string must not be empty!");
        }
        String[] splitted = parameterString.split("\\|\\|");
        if (splitted.length > 1) {
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String condition = stringArray[n2];
                condition = condition.trim();
                this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, condition));
                ++n2;
            }
            this.combinationMode = 1;
        } else {
            splitted = parameterString.split("\\&\\&");
            if (splitted.length > 1) {
                String[] stringArray = splitted;
                int n = splitted.length;
                int n3 = 0;
                while (n3 < n) {
                    String condition = stringArray[n3];
                    condition = condition.trim();
                    this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, condition));
                    ++n3;
                }
                this.combinationMode = 0;
            } else {
                this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, parameterString));
                this.combinationMode = 0;
            }
        }
    }

    private void addCondition(Attribute attribute, int comparisonType, String value) {
        this.addCondition(new AttributeValueFilterSingleCondition(attribute, comparisonType, value));
    }

    private void addCondition(AttributeValueFilterSingleCondition condition) {
        this.conditions.add(condition);
    }

    @Deprecated
    public Condition duplicate() {
        return this;
    }

    public String toString() {
        return this.conditions.toString();
    }

    public boolean conditionOk(Example e) {
        for (AttributeValueFilterSingleCondition condition : this.conditions) {
            if (this.combinationMode == 0) {
                if (condition.conditionOk(e)) continue;
                return false;
            }
            if (!condition.conditionOk(e)) continue;
            return true;
        }
        return this.combinationMode == 0;
    }
}

