/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.AbstractSparseArrayDataRow;

public class ShortSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private static final long serialVersionUID = 1688504268820756726L;
    private short[] values;

    public ShortSparseArrayDataRow() {
        this(0);
    }

    public ShortSparseArrayDataRow(int size) {
        super(size);
        this.values = new short[size];
    }

    protected void swapValues(int a, int b) {
        short tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    public void resizeValues(int length) {
        short[] d = new short[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, double v) {
        this.values[index] = (short)v;
    }

    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.values[i];
            ++i;
        }
        return result;
    }
}

