/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class DatabaseExampleVisualization
implements ObjectVisualizer {
    private DatabaseHandler handler;
    private PreparedStatement statement;

    public DatabaseExampleVisualization(String databaseURL, String userName, String password, int databaseSystem, String tableName, String columnName, LoggingHandler logging) {
        try {
            this.handler = DatabaseHandler.getConnectedDatabaseHandler(databaseURL, userName, password, DatabaseService.getJDBCProperties().get(databaseSystem), logging);
            String query = "SELECT * FROM " + this.handler.getProperties().getIdentifierQuoteOpen() + tableName + this.handler.getProperties().getIdentifierQuoteClose() + " WHERE " + this.handler.getProperties().getIdentifierQuoteOpen() + columnName + this.handler.getProperties().getIdentifierQuoteClose() + " = ?";
            this.statement = this.handler.createPreparedStatement(query, false);
        }
        catch (OperatorException e) {
            logging.logError("Cannot connect to database: " + e.getMessage());
        }
        catch (SQLException e) {
            logging.logError("Cannot connect to database: " + e.getMessage());
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.handler != null) {
            try {
                this.handler.disconnect();
                this.handler = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void startVisualization(Object objId) {
        if (this.handler == null || this.statement == null) {
            return;
        }
        try {
            this.statement.setObject(1, objId);
            ResultSet rs = this.statement.executeQuery();
            final JDialog dialog = new JDialog(RapidMinerGUI.getMainFrame(), "Example: " + objId, false);
            dialog.getContentPane().setLayout(new BorderLayout());
            if (rs != null) {
                boolean dataAvailable = rs.next();
                if (dataAvailable) {
                    ResultSetMetaData metaData = rs.getMetaData();
                    Object[] columnNames = new String[]{"Attribute", "Value"};
                    Object[][] data = new String[metaData.getColumnCount()][2];
                    int c = 1;
                    while (c <= data.length) {
                        data[c - 1][0] = metaData.getColumnName(c);
                        Object result = rs.getObject(c);
                        String value = "?";
                        if (result != null) {
                            value = result instanceof Number ? Tools.formatIntegerIfPossible(((Number)result).doubleValue()) : result.toString();
                        }
                        data[c - 1][1] = value;
                        ++c;
                    }
                    ExtendedJTable table = new ExtendedJTable();
                    table.setDefaultEditor(Object.class, null);
                    DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
                    ((JTable)table).setModel(tableModel);
                    ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(table);
                    dialog.getContentPane().add((Component)scrollPane, "Center");
                } else {
                    JLabel noInfoLabel = new JLabel("No information available for object '" + objId + "'.");
                    dialog.getContentPane().add((Component)noInfoLabel, "Center");
                }
            } else {
                JLabel noInfoLabel = new JLabel("No information available for object '" + objId + "'.");
                dialog.getContentPane().add((Component)noInfoLabel, "Center");
            }
            JPanel buttons = new JPanel(new FlowLayout());
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            buttons.add(okButton);
            dialog.getContentPane().add((Component)buttons, "South");
            dialog.pack();
            dialog.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
            dialog.setVisible(true);
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            SwingTools.showVerySimpleErrorMessage("Cannot retrieve information for object '" + objId + "':\n" + e.getMessage());
        }
    }

    public String getDetailData(Object objId, String fieldName) {
        if (this.handler == null || this.statement == null) {
            return null;
        }
        try {
            boolean dataAvailable;
            this.statement.setObject(1, objId);
            ResultSet rs = this.statement.executeQuery();
            String resultString = null;
            if (rs != null && (dataAvailable = rs.next())) {
                Object result = rs.getObject(fieldName);
                String value = "?";
                if (result != null) {
                    value = result instanceof Number ? Tools.formatIntegerIfPossible(((Number)result).doubleValue()) : result.toString();
                }
                resultString = value;
            }
            if (rs != null) {
                rs.close();
            }
            return resultString;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public String[] getFieldNames(Object objId) {
        if (this.handler == null || this.statement == null) {
            return new String[0];
        }
        try {
            boolean dataAvailable;
            this.statement.setObject(1, objId);
            ResultSet rs = this.statement.executeQuery();
            LinkedList<String> result = new LinkedList<String>();
            if (rs != null && (dataAvailable = rs.next())) {
                ResultSetMetaData metaData = rs.getMetaData();
                int c = 1;
                while (c <= metaData.getColumnCount()) {
                    result.add(metaData.getColumnName(c));
                    ++c;
                }
            }
            if (rs != null) {
                rs.close();
            }
            String[] resultArray = new String[result.size()];
            result.toArray(resultArray);
            return resultArray;
        }
        catch (SQLException e) {
            return new String[0];
        }
    }

    public String getTitle(Object objId) {
        return objId instanceof String ? (String)objId : ((Double)objId).toString();
    }

    public boolean isCapableToVisualize(Object id) {
        return true;
    }

    public void stopVisualization(Object objId) {
    }
}

