/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ExampleVisualizer
implements ObjectVisualizer {
    private ExampleSet exampleSet;
    private Attribute idAttribute;

    public ExampleVisualizer(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.exampleSet.remapIds();
        this.idAttribute = exampleSet.getAttributes().getId();
    }

    public void startVisualization(Object objId) {
        final JDialog dialog = new JDialog(RapidMinerGUI.getMainFrame(), "Example: " + objId, false);
        dialog.getContentPane().setLayout(new BorderLayout());
        double idValue = Double.NaN;
        idValue = this.idAttribute.isNominal() ? (objId instanceof String ? (double)this.idAttribute.getMapping().mapString((String)objId) : (Double)objId) : (objId instanceof String ? Double.parseDouble((String)objId) : (Double)objId);
        Example example = this.exampleSet.getExampleFromId(idValue);
        if (example != null) {
            Object[] columnNames = new String[]{"Attribute", "Value"};
            Object[][] data = new String[example.getAttributes().allSize()][2];
            Iterator<Attribute> a = example.getAttributes().allAttributes();
            int counter = 0;
            while (a.hasNext()) {
                Attribute attribute = a.next();
                data[counter][0] = attribute.getName();
                data[counter][1] = example.getValueAsString(attribute);
                ++counter;
            }
            ExtendedJTable table = new ExtendedJTable();
            table.setDefaultEditor(Object.class, null);
            DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
            ((JTable)table).setModel(tableModel);
            ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(table);
            dialog.getContentPane().add((Component)scrollPane, "Center");
        } else {
            JLabel noInfoLabel = new JLabel("No information available for object '" + objId + "'.");
            dialog.getContentPane().add((Component)noInfoLabel, "Center");
        }
        JPanel buttons = new JPanel(new FlowLayout());
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        buttons.add(okButton);
        dialog.getContentPane().add((Component)buttons, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
        dialog.setVisible(true);
    }

    public String getDetailData(Object objId, String fieldName) {
        double idValue = Double.NaN;
        idValue = this.idAttribute.isNominal() ? (objId instanceof String ? (double)this.idAttribute.getMapping().mapString((String)objId) : (Double)objId) : (objId instanceof String ? Double.parseDouble((String)objId) : (Double)objId);
        Example example = this.exampleSet.getExampleFromId(idValue);
        Attribute attribute = this.exampleSet.getAttributes().get(fieldName);
        if (attribute != null) {
            return example.getValueAsString(attribute);
        }
        return null;
    }

    public String[] getFieldNames(Object id) {
        return Tools.getAllAttributeNames(this.exampleSet);
    }

    public void stopVisualization(Object objId) {
    }

    public String getTitle(Object objId) {
        return objId instanceof String ? (String)objId : ((Double)objId).toString();
    }

    public boolean isCapableToVisualize(Object id) {
        double idValue;
        if (this.idAttribute.isNominal()) {
            double idValue2;
            double d = idValue2 = id instanceof String ? (double)this.idAttribute.getMapping().mapString((String)id) : (Double)id;
            return this.exampleSet.getExampleFromId(idValue2) != null;
        }
        double d = idValue = id instanceof String ? Double.parseDouble((String)id) : (Double)id;
        return this.exampleSet.getExampleFromId(idValue) != null;
    }
}

