/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import sun.awt.AppContext;

public class Tools {
    private static final Object sharedFrameKey = JOptionPane.class;
    private static final Object sharedOwnerFrameKey = new StringBuffer("SwingUtilities.sharedOwnerFrame");
    private static int width;
    private static int height;
    private static BufferedImage dest;
    private static BufferedImage dest2;
    private static Graphics g;
    private static float[] blurMatrix;
    private static Kernel blurKernel;
    private static ConvolveOp blurOperator;
    private static float[] sharpenMatrix;
    private static Kernel sharpenKernel;
    private static ConvolveOp sharpenOperator;
    private static BufferedImage srcBImage;

    static {
        blurMatrix = new float[]{0.055f, 0.055f, 0.055f, 0.055f, 0.66f, 0.055f, 0.055f, 0.055f, 0.055f};
        blurKernel = new Kernel(3, 3, blurMatrix);
        blurOperator = new ConvolveOp(blurKernel, 1, null);
        sharpenMatrix = new float[]{-0.03f, -0.03f, -0.03f, -0.03f, 1.24f, -0.03f, -0.03f, -0.03f, -0.03f};
        sharpenKernel = new Kernel(3, 3, sharpenMatrix);
        sharpenOperator = new ConvolveOp(sharpenKernel, 1, null);
    }

    private static Object getAppContext(Object key) {
        return AppContext.getAppContext().get(key);
    }

    private static void putAppContext(Object key, Object value) {
        AppContext.getAppContext().put(key, value);
    }

    private static Frame getSharedOwnerFrame() throws HeadlessException {
        Frame sharedOwnerFrame = (Frame)Tools.getAppContext(sharedOwnerFrameKey);
        if (sharedOwnerFrame == null) {
            sharedOwnerFrame = new Frame(){
                private static final long serialVersionUID = -3949166916666457066L;

                public void setVisible(boolean value) {
                }

                public synchronized void dispose() {
                    try {
                        this.getToolkit().getSystemEventQueue();
                        super.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Tools.putAppContext(sharedOwnerFrameKey, sharedOwnerFrame);
        }
        return sharedOwnerFrame;
    }

    private static Frame getRootFrame() throws HeadlessException {
        Frame sharedFrame = (Frame)Tools.getAppContext(sharedFrameKey);
        if (sharedFrame == null) {
            sharedFrame = Tools.getSharedOwnerFrame();
            Tools.putAppContext(sharedFrameKey, sharedFrame);
        }
        return sharedFrame;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return Tools.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return Tools.getWindowForComponent(parentComponent.getParent());
    }

    public static ImageIcon getSmallSystemIcon(Image img) throws Exception {
        if (img.getWidth(null) > 20 || img.getHeight(null) > 20) {
            if (img.getWidth(null) > img.getHeight(null)) {
                width = 18;
                height = img.getHeight(null) * 18 / img.getWidth(null);
            } else {
                height = 18;
                width = img.getWidth(null) * 18 / img.getHeight(null);
            }
        } else {
            return new ImageIcon(img);
        }
        dest = new BufferedImage(width, height, 6);
        dest2 = new BufferedImage(width, height, 6);
        g = dest.getGraphics();
        g.drawImage(img, 1, 1, width, height, null);
        g.dispose();
        blurOperator.filter(dest, dest2);
        return new ImageIcon(dest2);
    }

    public static ImageIcon getBigSystemIcon(Image image) throws Exception {
        if (image.getWidth(null) < 20 || image.getHeight(null) < 20) {
            if (image.getWidth(null) > image.getHeight(null)) {
                width = 24;
                height = image.getHeight(null) * 24 / image.getWidth(null);
            } else {
                height = 24;
                width = image.getWidth(null) * 24 / image.getHeight(null);
            }
        } else {
            return new ImageIcon(image);
        }
        dest = new BufferedImage(width, height, 5);
        dest2 = new BufferedImage(width, height, 5);
        g = dest.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 22, 22);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        sharpenOperator.filter(dest, dest2);
        return new ImageIcon(dest);
    }

    public static Image getScaledInstance(File file) throws Exception {
        srcBImage = ImageIO.read(file);
        if (srcBImage.getWidth() > srcBImage.getHeight()) {
            width = 100;
            height = srcBImage.getHeight() * 100 / srcBImage.getWidth();
        } else {
            height = 100;
            width = srcBImage.getWidth() * 100 / srcBImage.getHeight();
        }
        dest = new BufferedImage(width, height, 5);
        dest2 = new BufferedImage(width, height, 5);
        g = dest.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 100, 100);
        g.drawImage(srcBImage, 0, 0, width, height, null);
        g.dispose();
        srcBImage = null;
        blurOperator.filter(dest, dest2);
        return dest2;
    }
}

