/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.gui.processeditor.NewOperatorEditor;
import com.rapidminer.gui.processeditor.NewOperatorGroupTreeModel;
import com.rapidminer.gui.processeditor.NewOperatorGroupTreeRenderer;
import com.rapidminer.gui.processeditor.actions.ClearFilterAction;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class NewOperatorGroupTree
extends JPanel {
    private static final long serialVersionUID = 133086849304885475L;
    private static final String DEFAULT_FILTER_TEXT = "[Filter]";
    private JTextField filterField = new JTextField(12);
    private transient NewOperatorGroupTreeModel model = new NewOperatorGroupTreeModel(OperatorService.getGroups());
    private JTree operatorGroupTree = new JTree(this.model);
    private NewOperatorEditor editor;

    public NewOperatorGroupTree(NewOperatorEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.operatorGroupTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this.operatorGroupTree);
        this.operatorGroupTree.setToggleClickCount(5);
        this.operatorGroupTree.setCellRenderer(new NewOperatorGroupTreeRenderer());
        this.operatorGroupTree.expandRow(0);
        this.add((Component)new ExtendedJScrollPane(this.operatorGroupTree), "Center");
        this.filterField.setToolTipText("Insert a search string in order to filter the new operator tree above.");
        this.filterField.setForeground(Color.LIGHT_GRAY);
        this.filterField.setText(DEFAULT_FILTER_TEXT);
        this.filterField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                NewOperatorGroupTree.this.filterField.setForeground(Color.BLACK);
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                NewOperatorGroupTree.this.updateFilter(e);
            }
        });
        this.filterField.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                NewOperatorGroupTree.this.filterField.selectAll();
            }
        });
        this.filterField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                NewOperatorGroupTree.this.updateFilter(null);
            }
        });
        ExtendedJToolBar clearBar = new ExtendedJToolBar();
        clearBar.add(this.filterField);
        clearBar.add(new ClearFilterAction(this));
        clearBar.setBorder(null);
        this.add((Component)clearBar, "South");
    }

    public void clearFilter() {
        this.filterField.setForeground(Color.LIGHT_GRAY);
        this.filterField.setText(DEFAULT_FILTER_TEXT);
        this.updateFilter(null);
    }

    private void updateFilter(KeyEvent e) {
        String filterText = this.filterField.getText();
        if (!(filterText != null && filterText.trim().length() != 0 || e != null && (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 16 || e.getKeyCode() == 18 || e.getKeyCode() == 65406 || e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.isActionKey()))) {
            this.filterField.setForeground(Color.LIGHT_GRAY);
            this.filterField.setText(DEFAULT_FILTER_TEXT);
        }
        if (DEFAULT_FILTER_TEXT.equals(filterText)) {
            filterText = null;
        }
        this.model.applyFilter(filterText);
        GroupTree root = (GroupTree)this.operatorGroupTree.getModel().getRoot();
        TreePath path = new TreePath(root);
        this.showNodes(root, path);
    }

    private void showNodes(GroupTree tree, TreePath path) {
        if (tree.getSubGroups().size() == 0) {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            this.editor.setOperatorList(tree);
        } else if (tree.getSubGroups().size() == 1 && tree.getOperatorDescriptions().size() == 0) {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            GroupTree child = tree.getSubGroup(0);
            path = path.pathByAddingChild(child);
            this.showNodes(child, path);
        } else {
            int row = this.operatorGroupTree.getRowForPath(path);
            this.operatorGroupTree.expandRow(row);
            this.editor.setOperatorList(null);
        }
    }

    public JTree getTree() {
        return this.operatorGroupTree;
    }
}

