/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NewOperatorGroupTreeModel
implements TreeModel {
    private GroupTree completeTree;
    private GroupTree displayedTree;
    private List<TreeModelListener> treeModelListeners = new LinkedList<TreeModelListener>();

    public NewOperatorGroupTreeModel(GroupTree root) {
        this.displayedTree = this.completeTree = root;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        return ((GroupTree)parent).getSubGroup(index);
    }

    public int getChildCount(Object parent) {
        return ((GroupTree)parent).getSubGroups().size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((GroupTree)parent).getIndexOfSubGroup((GroupTree)child);
    }

    public Object getRoot() {
        return this.displayedTree;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object node) {
        this.fireTreeChanged(node, path);
    }

    private void fireTreeChanged(Object source, TreePath path) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(new TreeModelEvent(source, path));
        }
    }

    private void fireCompleteTreeChanged(Object source) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.getRoot())));
        }
    }

    public void applyFilter(String filter) {
        if (filter == null || filter.trim().length() == 0) {
            this.displayedTree = this.completeTree;
        } else {
            GroupTree filteredTree = (GroupTree)this.completeTree.clone();
            this.removeFilteredInstances(filter, filteredTree);
            this.displayedTree = filteredTree;
        }
        this.fireCompleteTreeChanged(this);
    }

    private void removeFilteredInstances(String filter, GroupTree filteredTree) {
        Iterator<GroupTree> g = filteredTree.getSubGroups().iterator();
        while (g.hasNext()) {
            GroupTree child = g.next();
            if (child.getName().toLowerCase().indexOf(filter.toLowerCase()) >= 0) continue;
            this.removeFilteredInstances(filter, child);
            if (child.getAllOperatorDescriptions().size() != 0) continue;
            g.remove();
        }
        if (filteredTree.getName().toLowerCase().indexOf(filter.toLowerCase()) < 0) {
            Iterator<OperatorDescription> o = filteredTree.getOperatorDescriptions().iterator();
            while (o.hasNext()) {
                OperatorDescription description = o.next();
                if (description.getName().toLowerCase().indexOf(filter.toLowerCase()) >= 0) continue;
                o.remove();
            }
        }
    }
}

