/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.report.Renderable;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class DendrogramPlotter
extends JPanel
implements Renderable {
    private static final long serialVersionUID = 2892192060246909733L;
    private static final int MARGIN = 10;
    private HierarchicalClusterModel hcm;
    private int numObjects;
    private double maxDistance;
    private double minDistance;
    private int maxX;
    private int maxY;
    private int count;
    private Color color = SwingTools.DARKEST_BLUE;

    public DendrogramPlotter(HierarchicalClusterModel hcm) {
        this.hcm = hcm;
        this.numObjects = hcm.getRootNode().getNumberOfExamplesInSubtree();
        this.minDistance = Double.POSITIVE_INFINITY;
        this.maxDistance = Double.NEGATIVE_INFINITY;
        this.findMinMaxDistance(hcm.getRootNode());
    }

    private void findMinMaxDistance(HierarchicalClusterNode node) {
        double distance = node.getDistance();
        this.maxDistance = Math.max(this.maxDistance, distance);
        this.minDistance = Math.min(this.minDistance, distance);
        for (HierarchicalClusterNode subNode : node.getSubNodes()) {
            this.findMinMaxDistance(subNode);
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics g) {
        g.setColor(this.color);
        g.drawLine(x1, y1, x2, y2);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.minDistance == this.maxDistance || Double.isNaN(this.minDistance) || Double.isInfinite(this.minDistance) || Double.isNaN(this.maxDistance) || Double.isInfinite(this.maxDistance)) {
            g.drawString("Dendrogram not available for this cluster model. Use an agglomerative clusterer.", 10, 25);
            return;
        }
        this.maxX = this.getWidth() - 20;
        this.maxY = this.getHeight() - 20;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics translated = g.create();
        translated.translate(10, 10);
        this.count = 0;
        this.paintRecursively(this.hcm.getRootNode(), this.hcm.getRootNode().getDistance(), translated);
    }

    private int weightToYPos(double weight) {
        return (int)Math.round((double)this.maxY * ((this.maxDistance - weight - this.minDistance) / (this.maxDistance - this.minDistance)));
    }

    private int countToXPos(int count) {
        return (int)Math.round((double)count / (double)this.numObjects * (double)this.maxX);
    }

    private int paintRecursively(HierarchicalClusterNode node, double baseDistance, Graphics g) {
        int currentPos;
        int leftPos = -1;
        int rightPos = -1;
        for (HierarchicalClusterNode subNode : node.getSubNodes()) {
            if (subNode.getNumberOfSubNodes() <= 0 && subNode.getNumberOfExamplesInSubtree() <= 1) continue;
            currentPos = this.paintRecursively(subNode, node.getDistance(), g);
            if (leftPos == -1) {
                leftPos = currentPos;
            }
            rightPos = currentPos;
        }
        for (HierarchicalClusterNode subNode : node.getSubNodes()) {
            if (subNode.getNumberOfExamplesInSubtree() != 1 || subNode.getNumberOfSubNodes() != 0) continue;
            currentPos = this.countToXPos(this.count);
            this.drawLine(currentPos, this.weightToYPos(node.getDistance()), currentPos, this.weightToYPos(this.minDistance), g);
            if (leftPos == -1) {
                leftPos = currentPos;
            }
            rightPos = currentPos;
            ++this.count;
        }
        int middlePos = (rightPos + leftPos) / 2;
        this.drawLine(middlePos, this.weightToYPos(baseDistance), middlePos, this.weightToYPos(node.getDistance()), g);
        this.drawLine(leftPos, this.weightToYPos(node.getDistance()), rightPos, this.weightToYPos(node.getDistance()), g);
        return middlePos;
    }

    public void prepareRendering() {
    }

    public void finishRendering() {
    }

    public int getRenderHeight(int preferredHeight) {
        int height = this.getHeight();
        if (height < 1) {
            height = preferredHeight;
        }
        return height;
    }

    public int getRenderWidth(int preferredWidth) {
        int width = this.getWidth();
        if (width < 1) {
            width = preferredWidth;
        }
        return width;
    }

    public void render(Graphics graphics, int width, int height) {
        this.setSize(width, height);
        this.paint(graphics);
    }
}

