/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1598719681189990076L;
    public static final int DEFAULT_MAX_NUMBER_OF_ROWS_FOR_STATISTICS = 100000;
    public static final int DEFAULT_MAX_DISPLAYED_VALUES = 50;
    public static final int TYPE = 0;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int SOURCE = 3;
    public static final int VALUE_TYPE = 4;
    public static final int BLOCK_TYPE = 5;
    public static final int STATISTICS_AVERAGE = 6;
    public static final int STATISTICS_RANGE = 7;
    public static final int STATISTICS_SUM = 8;
    public static final int STATISTICS_UNKNOWN = 9;
    public static final String[] COLUMN_NAMES = new String[]{"Type", "Index", "Name", "Construction", "Value Type", "Block Type", "Statistics", "Range", "Sum", "Unknown"};
    private static final String[] COLUMN_TOOL_TIPS = new String[]{"The type of the attribute (regular or one of the special types).", "The index of the attribute in the example table backing up this example set (view).", "The name of the attribute.", "The construction source of the attribute, i.e. how it was generated.", "The value type of this attribute, e.g. if the attribute is nominal or numerical.", "The block type of this attribute, e.g. if the attribute is a single attribute or part of a series.", "Basic statistics about the data set values with respect to this attribute.", "The range about the data set values with respect to this attribute (only numerical attributes).", "The sum of all values in the data set for this attribute.", "The number of unknown values in the data set for this attribute"};
    public static final Class[] COLUMN_CLASSES = new Class[]{String.class, Double.class, String.class, String.class, String.class, String.class, String.class, String.class, Double.class, Double.class};
    private int[] currentMapping;
    private ExampleSet exampleSet;
    private Attribute[] regularAttributes;
    private Attribute[] specialAttributes;
    private String[] specialAttributeNames;

    public MetaDataViewerTableModel(ExampleSet exampleSet) {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 7;
        nArray[5] = 9;
        this.currentMapping = nArray;
        this.regularAttributes = new Attribute[0];
        this.specialAttributes = new Attribute[0];
        this.specialAttributeNames = new String[0];
        this.exampleSet = exampleSet;
        if (this.exampleSet != null) {
            this.regularAttributes = Tools.createRegularAttributeArray(exampleSet);
            this.specialAttributes = new Attribute[exampleSet.getAttributes().specialSize()];
            this.specialAttributeNames = new String[exampleSet.getAttributes().specialSize()];
            Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
            int counter = 0;
            while (i.hasNext()) {
                AttributeRole role = i.next();
                this.specialAttributeNames[counter] = role.getSpecialName();
                this.specialAttributes[counter] = role.getAttribute();
                ++counter;
            }
            int maxNumberForStatistics = 100000;
            String maxString = System.getProperty("rapidminer.gui.max_statistics_rows");
            if (maxString != null) {
                try {
                    maxNumberForStatistics = Integer.parseInt(maxString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (exampleSet.size() < maxNumberForStatistics) {
                this.calculateStatistics();
            } else {
                this.setShowColumn(6, false);
                this.setShowColumn(7, false);
                this.setShowColumn(8, false);
                this.setShowColumn(9, false);
            }
        }
    }

    public void calculateStatistics() {
        this.exampleSet.recalculateAllAttributeStatistics();
        this.setShowColumn(6, true);
        this.setShowColumn(7, true);
        this.setShowColumn(9, true);
    }

    public void setShowColumn(int index, boolean show) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            if (i == index) {
                if (show) {
                    result.add(i);
                }
            } else if (this.getShowColumn(i)) {
                result.add(i);
            }
            ++i;
        }
        this.currentMapping = new int[result.size()];
        Iterator i2 = result.iterator();
        int counter = 0;
        while (i2.hasNext()) {
            this.currentMapping[counter++] = (Integer)i2.next();
        }
        this.fireTableStructureChanged();
    }

    public boolean getShowColumn(int index) {
        int i = 0;
        while (i < this.currentMapping.length) {
            if (this.currentMapping[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.exampleSet != null) {
            return this.exampleSet.getAttributes().specialSize() + this.exampleSet.getAttributes().size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.exampleSet != null) {
            return this.currentMapping.length;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Attribute attribute = null;
        String type = "regular";
        if (row < this.specialAttributes.length) {
            attribute = this.specialAttributes[row];
            type = this.specialAttributeNames[row];
        } else {
            attribute = this.regularAttributes[row - this.specialAttributes.length];
        }
        int actualColumn = this.currentMapping[col];
        switch (actualColumn) {
            case 0: {
                return type;
            }
            case 1: {
                return attribute.getTableIndex();
            }
            case 2: {
                return attribute.getName();
            }
            case 3: {
                return attribute.getConstruction();
            }
            case 4: {
                return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType());
            }
            case 5: {
                return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType());
            }
            case 6: {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    long minMilliseconds = (long)this.exampleSet.getStatistics(attribute, "minimum");
                    long maxMilliseconds = (long)this.exampleSet.getStatistics(attribute, "maximum");
                    long difference = maxMilliseconds - minMilliseconds;
                    String duration = "length = ";
                    if (attribute.getValueType() == 10) {
                        duration = String.valueOf(duration) + com.rapidminer.tools.Tools.formatIntegerIfPossible(Math.round((double)difference / 8.64E7)) + " days";
                    } else if (attribute.getValueType() == 11) {
                        duration = String.valueOf(duration) + com.rapidminer.tools.Tools.formatIntegerIfPossible(Math.round((double)difference / 3600000.0)) + " hours";
                    } else if (attribute.getValueType() == 9) {
                        duration = String.valueOf(duration) + com.rapidminer.tools.Tools.formatIntegerIfPossible(Math.round((double)difference / 8.64E7)) + " days";
                    }
                    return duration;
                }
                if (attribute.isNominal()) {
                    int modeIndex = (int)this.exampleSet.getStatistics(attribute, "mode");
                    String mode = null;
                    try {
                        if (modeIndex != -1) {
                            mode = attribute.getMapping().mapIndex(modeIndex);
                        }
                    }
                    catch (AttributeTypeException maxMilliseconds) {
                        // empty catch block
                    }
                    int leastIndex = (int)this.exampleSet.getStatistics(attribute, "least");
                    String least = null;
                    try {
                        if (leastIndex != -1) {
                            least = attribute.getMapping().mapIndex(leastIndex);
                        }
                    }
                    catch (AttributeTypeException difference) {
                        // empty catch block
                    }
                    StringBuffer result = new StringBuffer();
                    if (mode == null) {
                        return result.append("mode = unknown");
                    }
                    result.append("mode = " + mode + " (" + com.rapidminer.tools.Tools.formatIntegerIfPossible(this.exampleSet.getStatistics(attribute, "count", mode)) + ")");
                    if (least == null) {
                        return result.append(", least = unknown");
                    }
                    result.append(", least = " + least + " (" + com.rapidminer.tools.Tools.formatIntegerIfPossible(this.exampleSet.getStatistics(attribute, "count", least)) + ")");
                    return result.toString();
                }
                double average = this.exampleSet.getStatistics(attribute, "average");
                double variance = Math.sqrt(this.exampleSet.getStatistics(attribute, "variance"));
                return "avg = " + com.rapidminer.tools.Tools.formatIntegerIfPossible(average) + " +/- " + com.rapidminer.tools.Tools.formatIntegerIfPossible(variance);
            }
            case 7: {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    long minMilliseconds = (long)this.exampleSet.getStatistics(attribute, "minimum");
                    long maxMilliseconds = (long)this.exampleSet.getStatistics(attribute, "maximum");
                    String minResult = null;
                    String maxResult = null;
                    if (attribute.getValueType() == 10) {
                        minResult = com.rapidminer.tools.Tools.formatDate(new Date(minMilliseconds));
                        maxResult = com.rapidminer.tools.Tools.formatDate(new Date(maxMilliseconds));
                    } else if (attribute.getValueType() == 11) {
                        minResult = com.rapidminer.tools.Tools.formatTime(new Date(minMilliseconds));
                        maxResult = com.rapidminer.tools.Tools.formatTime(new Date(maxMilliseconds));
                    } else if (attribute.getValueType() == 9) {
                        minResult = com.rapidminer.tools.Tools.formatDateTime(new Date(minMilliseconds));
                        maxResult = com.rapidminer.tools.Tools.formatDateTime(new Date(maxMilliseconds));
                    }
                    return "[" + minResult + " ; " + maxResult + "]";
                }
                if (attribute.isNominal()) {
                    int maxDisplayValues = 25;
                    String maxString = System.getProperty("rapidminer.gui.max_displayed_values");
                    if (maxString != null) {
                        try {
                            maxDisplayValues = Integer.parseInt(maxString) / 2;
                        }
                        catch (NumberFormatException maxMilliseconds) {
                            // empty catch block
                        }
                    }
                    StringBuffer str = new StringBuffer();
                    int totalNumberOfValues = attribute.getMapping().size();
                    if (totalNumberOfValues > 2 * maxDisplayValues) {
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        class ValueAndCount
                        implements Comparable<ValueAndCount> {
                            String value;
                            int count;

                            ValueAndCount(String value, int count) {
                                this.value = value;
                                this.count = count;
                            }

                            @Override
                            public int compareTo(ValueAndCount o) {
                                int result = -1 * Double.compare(this.count, o.count);
                                if (result == 0) {
                                    return this.value.compareTo(o.value);
                                }
                                return result;
                            }
                        }
                        ArrayList<ValueAndCount> valuesAndCounts = new ArrayList<ValueAndCount>();
                        for (String value : attribute.getMapping().getValues()) {
                            valuesAndCounts.add(new ValueAndCount(value, (int)this.exampleSet.getStatistics(attribute, "count", value)));
                        }
                        Collections.sort(valuesAndCounts);
                        Iterator f = valuesAndCounts.iterator();
                        int n = 0;
                        while (f.hasNext()) {
                            if (n > maxDisplayValues) break;
                            if (n > 0) {
                                str.append(", ");
                            }
                            ++n;
                            ValueAndCount valueAndCount = (ValueAndCount)f.next();
                            str.append(valueAndCount.value);
                            str.append(" (" + valueAndCount.count + ")");
                        }
                        str.append(", ... and " + (valuesAndCounts.size() - 2 * maxDisplayValues) + " more ... ");
                        ListIterator l = valuesAndCounts.listIterator(valuesAndCounts.size() - 1 - maxDisplayValues);
                        while (l.hasNext()) {
                            str.append(", ");
                            ValueAndCount valueAndCount = (ValueAndCount)l.next();
                            str.append(valueAndCount.value);
                            str.append(" (" + valueAndCount.count + ")");
                        }
                    } else {
                        Iterator<String> i = attribute.getMapping().getValues().iterator();
                        int n = 0;
                        while (i.hasNext()) {
                            String value = i.next();
                            if (n > 0) {
                                str.append(", ");
                            }
                            ++n;
                            int count = (int)this.exampleSet.getStatistics(attribute, "count", value);
                            str.append(String.valueOf(value) + " (" + count + ")");
                        }
                    }
                    return str.toString();
                }
                return "[" + com.rapidminer.tools.Tools.formatNumber(this.exampleSet.getStatistics(attribute, "minimum")) + " ; " + com.rapidminer.tools.Tools.formatNumber(this.exampleSet.getStatistics(attribute, "maximum")) + "]";
            }
            case 8: {
                return this.exampleSet.getStatistics(attribute, "sum");
            }
            case 9: {
                return this.exampleSet.getStatistics(attribute, "unknown");
            }
        }
        return "unknown";
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[this.currentMapping[col]];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return COLUMN_CLASSES[this.currentMapping[col]];
    }

    public String getColumnToolTip(int column) {
        if (column < 0 || column >= this.currentMapping.length) {
            return "";
        }
        return COLUMN_TOOL_TIPS[this.currentMapping[column]];
    }
}

