/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.operator.learner.subgroups.RuleSet;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.Accuracy;
import com.rapidminer.operator.learner.subgroups.utility.Bias;
import com.rapidminer.operator.learner.subgroups.utility.Binomial;
import com.rapidminer.operator.learner.subgroups.utility.Coverage;
import com.rapidminer.operator.learner.subgroups.utility.Lift;
import com.rapidminer.operator.learner.subgroups.utility.Odds;
import com.rapidminer.operator.learner.subgroups.utility.OddsRatio;
import com.rapidminer.operator.learner.subgroups.utility.Precision;
import com.rapidminer.operator.learner.subgroups.utility.Squared;
import com.rapidminer.operator.learner.subgroups.utility.WRAcc;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4323147898914632476L;
    private static final String[] COLUMN_NAMES = new String[]{"Premise", "Conclusion", "Pos", "Neg", "Size", "Coverage", "Precision", "Accuracy", "Bias", "Lift", "Binomial", "WRAcc", "Squared", "Odds", "Odds Ratio", "Length"};
    private static final int COLUMN_PREMISES = 0;
    private static final int COLUMN_CONCLUSION = 1;
    private static final int COLUMN_POSITIVE = 2;
    private static final int COLUMN_NEGATIVE = 3;
    private static final int COLUMN_SIZE = 4;
    private static final int COLUMN_COVERAGE = 5;
    private static final int COLUMN_PRECISION = 6;
    private static final int COLUMN_ACCURACY = 7;
    private static final int COLUMN_BIAS = 8;
    private static final int COLUMN_LIFT = 9;
    private static final int COLUMN_BINOMIAL = 10;
    private static final int COLUMN_WRACC = 11;
    private static final int COLUMN_SQUARED = 12;
    private static final int COLUMN_ODDS = 13;
    private static final int COLUMN_OR = 14;
    private static final int COLUMN_LENGTH = 15;
    private RuleSet rules;

    public RuleSetTableModel(RuleSet rules) {
        this.rules = rules;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column != 0 && column != 1) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.rules.getNumberOfRules();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Rule rule = this.rules.getRule(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rule.getPremise().toString();
            }
            case 1: {
                return rule.getConclusion().getValueAsString();
            }
            case 2: {
                return rule.getPositiveWeight();
            }
            case 3: {
                return rule.getNegativeWeight();
            }
            case 4: {
                return rule.getCoveredWeight();
            }
            case 5: {
                return rule.getUtility(Coverage.class);
            }
            case 6: {
                return rule.getUtility(Precision.class);
            }
            case 7: {
                return rule.getUtility(Accuracy.class);
            }
            case 8: {
                return rule.getUtility(Bias.class);
            }
            case 9: {
                return rule.getUtility(Lift.class);
            }
            case 10: {
                return rule.getUtility(Binomial.class);
            }
            case 11: {
                return rule.getUtility(WRAcc.class);
            }
            case 12: {
                return rule.getUtility(Squared.class);
            }
            case 13: {
                return rule.getUtility(Odds.class);
            }
            case 14: {
                return rule.getUtility(OddsRatio.class);
            }
            case 15: {
                return rule.getHypothesis().getNumberOfLiterals();
            }
        }
        return "?";
    }
}

