/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.XMLSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractIOObject
implements IOObject {
    private static final long serialVersionUID = 7131412868947165460L;
    private String source = null;
    private transient LoggingHandler loggingHandler;

    public void setSource(String sourceName) {
        this.source = sourceName;
    }

    public String getSource() {
        return this.source;
    }

    public LoggingHandler getLog() {
        if (this.loggingHandler != null) {
            return this.loggingHandler;
        }
        return LogService.getGlobal();
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public IOObject copy() {
        return this;
    }

    protected void initWriting() {
    }

    public final void write(OutputStream out) throws IOException {
        this.initWriting();
        XMLSerialization.getXMLSerialization().writeXML(this, out);
    }

    public static IOObject read(InputStream in) throws IOException {
        XMLSerialization serializer = XMLSerialization.getXMLSerialization();
        if (serializer == null) {
            throw new IllegalStateException("XMLSerialization not initialized, please invoke XMLSerialization.init(ClassLoader) before using this method.");
        }
        return (IOObject)serializer.fromXML(in);
    }
}

