/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOStorageOperator
extends Operator {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_STORE_WHICH = "store_which";
    public static final String PARAMETER_REMOVE_FROM_PROCESS = "remove_from_process";
    private String[] objectArray = null;

    public IOStorageOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Class<IOObject> clazz = this.getSelectedClass();
        IOObject object = null;
        if (clazz != null) {
            int number = this.getParameterAsInt(PARAMETER_STORE_WHICH);
            object = this.getInput(clazz, number - 1);
            if (this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_PROCESS)) {
                this.getProcess().store(this.getParameterAsString(PARAMETER_NAME), object);
            } else {
                this.getProcess().store(this.getParameterAsString(PARAMETER_NAME), object.copy());
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_PROCESS) || object == null) {
            return new IOObject[0];
        }
        return new IOObject[]{object};
    }

    @Override
    public Class<?>[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            boolean remove = true;
            try {
                remove = this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_PROCESS);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (remove) {
                return new Class[0];
            }
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name under which the specified object is stored and can later be retrieved.", false));
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object which should be stored.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_STORE_WHICH, "Defines which input object should be stored.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(true);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_FROM_PROCESS, "Indicates if the stored object should be removed from the process so that following operators can only access this object after retrieving it.", true));
        return types;
    }
}

