/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueString;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMacroDefinitionOperator
extends Operator {
    public static final String PARAMETER_MACRO = "macro";
    public static final String PARAMETER_VALUE = "value";

    public SingleMacroDefinitionOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueString("macro_name", "The name of the macro."){

            public String getStringValue() {
                try {
                    return SingleMacroDefinitionOperator.this.getParameterAsString(SingleMacroDefinitionOperator.PARAMETER_MACRO);
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
        this.addValue(new ValueString("macro_value", "The value of the macro."){

            public String getStringValue() {
                try {
                    return SingleMacroDefinitionOperator.this.getParameterAsString(SingleMacroDefinitionOperator.PARAMETER_VALUE);
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String macro = this.getParameterAsString(PARAMETER_MACRO);
        String value = this.getParameterAsString(PARAMETER_VALUE);
        this.getProcess().getMacroHandler().addMacro(macro, value);
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_MACRO, "The macro name defined by the user.", false));
        types.add(new ParameterTypeString(PARAMETER_VALUE, "The macro value defined by the user.", false));
        return types;
    }
}

