/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.AbstractGeneticAlgorithm;
import com.rapidminer.operator.features.selection.SelectionCrossover;
import com.rapidminer.operator.features.selection.SelectionMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneticAlgorithm
extends AbstractGeneticAlgorithm {
    public static final String PARAMETER_P_INITIALIZE = "p_initialize";
    public static final String PARAMETER_P_MUTATION = "p_mutation";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";
    public static final String PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS = "initialize_with_input_weights";

    public GeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Population createInitialPopulation(ExampleSet es) throws OperatorException {
        block22: {
            minNumber = this.getParameterAsInt("min_number_of_attributes");
            maxNumber = this.getParameterAsInt("max_number_of_attributes");
            exactNumber = this.getParameterAsInt("exact_number_of_attributes");
            if (exactNumber > 0) {
                this.logNote("Using exact number of features for feature selection (" + exactNumber + "), ignoring possibly defined range for the number of features and / or input attribute weights.");
            } else if (maxNumber > 0 && minNumber > maxNumber) {
                throw new UserError((Operator)this, 210, new Object[]{"max_number_of_attributes", "min_number_of_attributes"});
            }
            initP = new Population();
            initialWeights = null;
            if (this.getParameterAsBoolean("initialize_with_input_weights")) {
                inputWeights = null;
                try {
                    inputWeights = this.getInput(AttributeWeights.class);
                    initialWeights = new double[es.getAttributes().size()];
                    index = 0;
                    for (Attribute attribute : es.getAttributes()) {
                        weight = inputWeights.getWeight(attribute.getName());
                        if (Double.isNaN(weight)) {
                            weight = this.getRandom().nextDouble();
                        }
                        if (weight < 0.0) {
                            weight = 0.0;
                        }
                        if (weight > 1.0) {
                            weight = 1.0;
                        }
                        if (weight > 0.0 && weight < 1.0) {
                            weight = weight < 1.0 - this.getParameterAsDouble("p_initialize") ? 1.0 : 0.0;
                        }
                        initialWeights[index++] = weight;
                    }
                    if (exactNumber < 0) {
                        individual = new Individual(initialWeights);
                        numberOfFeatures = individual.getNumberOfUsedAttributes();
                        if ((maxNumber < 1 || numberOfFeatures <= maxNumber) && numberOfFeatures >= minNumber) {
                            initP.add(individual);
                        } else {
                            this.logWarning("Input attribute weights found but number of selected features do not match specified minimum and maximum number, ignoring input weights.");
                            initialWeights = null;
                        }
                    }
                }
                catch (MissingIOObjectException index) {
                    // empty catch block
                }
            }
            if (exactNumber <= 0) ** GOTO lbl73
            while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
                weights = new double[es.getAttributes().size()];
                prob = 1.0 / (double)weights.length * (double)exactNumber;
                i = 0;
                while (i < weights.length) {
                    weights[i] = this.getRandom().nextDouble() < prob ? 1.0 : 0.0;
                    ++i;
                }
                individual = new Individual(weights);
                numberOfFeatures = individual.getNumberOfUsedAttributes();
                if (exactNumber != numberOfFeatures) continue;
                initP.add(individual);
            }
            break block22;
lbl-1000:
            // 1 sources

            {
                weights = new double[es.getAttributes().size()];
                if (initialWeights != null && this.getRandom().nextBoolean()) {
                    i = 0;
                    while (i < weights.length) {
                        weights[i] = this.getRandom().nextDouble() < 1.0 / (double)initialWeights.length ? (initialWeights[i] > 0.0 ? 0.0 : 1.0) : initialWeights[i];
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < weights.length) {
                        if (this.getRandom().nextDouble() < 1.0 - this.getParameterAsDouble("p_initialize")) {
                            weights[i] = 1.0;
                        }
                        ++i;
                    }
                }
                individual = new Individual(weights);
                numberOfFeatures = individual.getNumberOfUsedAttributes();
                if (maxNumber >= 1 && numberOfFeatures > maxNumber || numberOfFeatures < minNumber) continue;
                initP.add(individual);
lbl73:
                // 3 sources

                ** while (initP.getNumberOfIndividuals() < this.getParameterAsInt((String)"population_size"))
            }
        }
        return initP;
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsDouble(PARAMETER_P_MUTATION);
        int minNumber = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumber = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
        int exactNumber = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
        return new SelectionMutation(pMutation, this.getRandom(), minNumber, maxNumber, exactNumber);
    }

    @Override
    protected PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pCrossover = this.getParameterAsDouble(PARAMETER_P_CROSSOVER);
        int crossoverType = this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE);
        int minNumber = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumber = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
        int exactNumber = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
        return new SelectionCrossover(crossoverType, pCrossover, this.getRandom(), minNumber, maxNumber, exactNumber);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of features used for the combinations (-1: try all combinations up to possible maximum)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of features used for the combinations (-1: use the feature range defined by min and max).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_P_INITIALIZE, "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5));
        type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for an attribute to be changed (-1: 1 / numberOfAtt).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS, "Indicates if this operator should look for attribute weights in the given input and use the input weights of all known attributes as starting point for the optimization.", false));
        return types;
    }
}

