/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class StochasticUniversalSampling
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;
    private Random random;

    public StochasticUniversalSampling(int popSize, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public double filterFitness(double fitness) {
        return fitness;
    }

    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (this.keepBest) {
            newGeneration.add(population.getBestIndividualEver());
        }
        int numberOfMarks = this.popSize - newGeneration.size();
        double distance = 1.0 / (double)numberOfMarks;
        double r = this.random.nextDouble() / (double)numberOfMarks;
        int i = 0;
        while (i < numberOfMarks) {
            double f = 0.0;
            int j = 0;
            Individual individual = null;
            while ((f += this.filterFitness((individual = population.get(j++)).getPerformance().getMainCriterion().getFitness())) < r) {
            }
            newGeneration.add(individual);
            r += distance;
            ++i;
        }
        population.clear();
        population.addAllIndividuals(newGeneration);
    }
}

