/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import com.rapidminer.operator.features.transformation.EigenvectorModelVisualization;
import com.rapidminer.operator.features.transformation.WeightVector;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GHAModel
extends AbstractModel
implements ComponentWeightsCreatable {
    private static final long serialVersionUID = -5204076842779376622L;
    private int numberOfAttributes;
    private int numberOfComponents;
    private double[] means;
    private String[] attributeNames;
    private List<WeightVector> weightVectors;
    private boolean keepAttributes = false;

    public GHAModel(ExampleSet eSet, double[] eigenvalues, double[][] weights, double[] mean) {
        super(eSet);
        this.numberOfAttributes = weights[0].length;
        this.numberOfComponents = weights.length;
        this.means = mean;
        this.attributeNames = new String[this.numberOfAttributes];
        int i = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            this.attributeNames[i++] = attribute.getName();
        }
        this.weightVectors = new ArrayList<WeightVector>(eigenvalues.length);
        i = 0;
        while (i < eigenvalues.length) {
            double[] currentVector = new double[eSet.getAttributes().size()];
            int j = 0;
            while (j < currentVector.length) {
                currentVector[j] = weights[j][i];
                ++j;
            }
            this.weightVectors.add(new WeightVector(currentVector, eigenvalues[i]));
            ++i;
        }
        Collections.sort(this.weightVectors);
    }

    public double[] getMean() {
        return this.means;
    }

    public double[] getWeights(int index) {
        return this.weightVectors.get(index).getWeights();
    }

    public double getEigenvalue(int index) {
        return this.weightVectors.get(index).getEigenvalue();
    }

    public double getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Example example;
        exampleSet.recalculateAllAttributeStatistics();
        if (this.numberOfAttributes != exampleSet.getAttributes().size()) {
            throw new UserError(null, 133, this.numberOfAttributes, exampleSet.getAttributes().size());
        }
        this.log("Number of components: " + this.numberOfComponents);
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        boolean haslabel = exampleSet.getAttributes().getLabel() != null;
        boolean haspredlabel = exampleSet.getAttributes().getPredictedLabel() != null;
        double[] labelvalues = new double[]{};
        double[] predvalues = new double[]{};
        if (haslabel) {
            labelvalues = new double[exampleSet.size()];
        }
        if (haspredlabel) {
            predvalues = new double[exampleSet.size()];
        }
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < exampleSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                if (haslabel) {
                    labelvalues[sample] = example.getValue(example.getAttributes().getLabel());
                }
                if (haspredlabel) {
                    predvalues[sample] = example.getValue(example.getAttributes().getPredictedLabel());
                }
                ++d;
            }
            ++sample;
        }
        Matrix dataMatrix = new Matrix(data);
        double[][] values = new double[this.weightVectors.size()][this.attributeNames.length];
        int counter = 0;
        for (WeightVector wv : this.weightVectors) {
            values[counter++] = wv.getWeights();
        }
        Matrix W = new Matrix(values);
        Matrix finaldataMatrix = dataMatrix.times(W.transpose());
        double[][] finaldata = finaldataMatrix.getArray();
        if (!this.keepAttributes) {
            exampleSet.getAttributes().clearRegular();
        }
        this.log("Adding new the derived features...");
        Attribute[] principalComponentAttributes = new Attribute[this.numberOfComponents];
        int i = 0;
        while (i < this.numberOfComponents) {
            principalComponentAttributes[i] = AttributeFactory.createAttribute("pc_" + (i + 1), 4);
            exampleSet.getExampleTable().addAttribute(principalComponentAttributes[i]);
            exampleSet.getAttributes().addRegular(principalComponentAttributes[i]);
            ++i;
        }
        reader = exampleSet.iterator();
        int sample2 = 0;
        while (sample2 < exampleSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            while (d < this.numberOfComponents) {
                example.setValue(principalComponentAttributes[d], finaldata[sample2][d]);
                ++d;
            }
            ++sample2;
        }
        return exampleSet;
    }

    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.numberOfComponents = Math.min(this.numberOfComponents, Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.attributeNames.length) {
            this.logWarning("Creating weights of component " + this.attributeNames.length + "!");
            component = this.attributeNames.length;
        }
        AttributeWeights weights = new AttributeWeights();
        int i = 0;
        while (i < this.attributeNames.length) {
            weights.setWeight(this.attributeNames[i], this.weightVectors.get(component - 1).getWeights()[i]);
            ++i;
        }
        return weights;
    }

    public Component getVisualizationComponent(IOContainer container) {
        double[] cumulativeVariance = new double[this.numberOfComponents];
        double cumulative = 0.0;
        int i = 0;
        for (WeightVector wv : this.weightVectors) {
            cumulativeVariance[i++] = cumulative += wv.getEigenvalue();
        }
        return new EigenvectorModelVisualization(this.getName(), this.attributeNames, cumulativeVariance, this.weightVectors, false, this.numberOfComponents, 1.0).getVisualizationComponent(container);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(Tools.getLineSeparator()) + "GHA Components:" + Tools.getLineSeparator());
        int i = 0;
        while (i < this.weightVectors.size()) {
            result.append("PC " + (i + 1) + ": ");
            int j = 0;
            while (j < this.attributeNames.length) {
                double value = this.weightVectors.get(j).getWeights()[i];
                if (value > 0.0) {
                    result.append(" + ");
                } else {
                    result.append(" - ");
                }
                result.append(String.valueOf(Tools.formatNumber(Math.abs(value))) + " * " + this.attributeNames[j]);
                ++j;
            }
            result.append(Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }
}

