/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaAttributeWeighting
extends AbstractWeighting
implements TechnicalInformationHandler {
    public static final String[] WEKA_ATTRIBUTE_EVALUATORS = WekaTools.getWekaClasses(AttributeEvaluator.class);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaAttributeWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        AttributeWeights weights = new AttributeWeights();
        ASEvaluation evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "WeightingInstances", 4);
        try {
            this.log("Building Weka attribute evaluator.");
            evaluator.buildEvaluator(instances);
        }
        catch (UnassignedClassException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, this.getOperatorClassName(), e);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, this.getOperatorClassName(), e);
        }
        int index = 0;
        if (evaluator instanceof AttributeEvaluator) {
            AttributeEvaluator singleEvaluator = (AttributeEvaluator)evaluator;
            for (Attribute attribute : exampleSet.getAttributes()) {
                try {
                    double result = singleEvaluator.evaluateAttribute(index++);
                    weights.setWeight(attribute.getName(), result);
                }
                catch (Exception e) {
                    this.logWarning("Cannot evaluate attribute '" + attribute.getName() + "', use unknown weight.");
                }
            }
        } else {
            this.logWarning("Cannot evaluate attributes, use unknown weights.");
        }
        return weights;
    }

    private ASEvaluation getWekaAttributeEvaluator(String prefixName, String[] parameters) throws OperatorException {
        String actualName = prefixName.substring("W-".length());
        String evaluatorName = null;
        int i = 0;
        while (i < WEKA_ATTRIBUTE_EVALUATORS.length) {
            if (WEKA_ATTRIBUTE_EVALUATORS[i].endsWith(actualName)) {
                evaluatorName = WEKA_ATTRIBUTE_EVALUATORS[i];
                break;
            }
            ++i;
        }
        ASEvaluation evaluator = null;
        try {
            evaluator = ASEvaluation.forName(evaluatorName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, evaluatorName, e);
        }
        return evaluator;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            ASEvaluation evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), null);
            if (evaluator instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)evaluator).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ASEvaluation evaluator = null;
        try {
            evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka attribute evaluator " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (evaluator != null && evaluator instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)evaluator, types, this.wekaParameters, false, null);
        }
        return types;
    }
}

