/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.weighting.WeightingMutation;
import java.util.Iterator;
import java.util.LinkedList;

public class VarianceAdaption
implements PopulationOperator {
    private WeightingMutation weightingMutation = null;
    private int intervalSize = 400;
    private LinkedList<Boolean> successList = new LinkedList();

    public VarianceAdaption(WeightingMutation weightingMutation, int intervalSize) {
        this.weightingMutation = weightingMutation;
        this.intervalSize = intervalSize;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(Population population) {
        if (population.getGenerationsWithoutImproval() < 2) {
            this.successList.add(true);
        } else {
            this.successList.add(false);
        }
        if (population.getGeneration() >= 10 * this.intervalSize) {
            this.successList.removeFirst();
            if (population.getGeneration() % this.intervalSize == 0) {
                int successCount = 0;
                Iterator i = this.successList.iterator();
                while (i.hasNext()) {
                    if (!((Boolean)i.next()).booleanValue()) continue;
                    ++successCount;
                }
                if ((double)successCount / (10.0 * (double)this.intervalSize) < 0.2) {
                    this.weightingMutation.setVariance(this.weightingMutation.getVariance() * 0.85);
                } else {
                    this.weightingMutation.setVariance(this.weightingMutation.getVariance() / 0.85);
                }
            }
        }
    }
}

