/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AbstractSparseArrayDataRow;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassiveDataGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_NUMBER_ATTRIBUTES = "number_attributes";
    public static final String PARAMETER_SPARSE_FRACTION = "sparse_fraction";
    public static final String PARAMETER_SPARSE_REPRESENTATION = "sparse_representation";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public MassiveDataGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        int numberOfAttributes = this.getParameterAsInt(PARAMETER_NUMBER_ATTRIBUTES);
        double sparseFraction = this.getParameterAsDouble(PARAMETER_SPARSE_FRACTION);
        boolean sparseRepresentation = this.getParameterAsBoolean(PARAMETER_SPARSE_REPRESENTATION);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int m = 0;
        while (m < numberOfAttributes) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("positive");
        label.getMapping().mapString("negative");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            double value;
            int i;
            Object dataRow;
            int counter = 0;
            if (sparseRepresentation) {
                dataRow = new DoubleSparseArrayDataRow(numberOfAttributes + 1);
                i = 0;
                while (i < numberOfAttributes) {
                    value = random.nextDouble() > sparseFraction ? 1.0 : 0.0;
                    ((DataRow)dataRow).set((Attribute)attributes.get(i), value);
                    if (value == 0.0) {
                        ++counter;
                    }
                    ++i;
                }
                if ((double)counter < sparseFraction * (double)numberOfAttributes) {
                    ((DataRow)dataRow).set(label, label.getMapping().mapString("positive"));
                } else {
                    ((DataRow)dataRow).set(label, label.getMapping().mapString("negative"));
                }
                ((AbstractSparseArrayDataRow)dataRow).trim();
                table.addDataRow((DataRow)dataRow);
            } else {
                dataRow = new double[numberOfAttributes + 1];
                i = 0;
                while (i < numberOfAttributes) {
                    dataRow[i] = value = random.nextDouble() > sparseFraction ? 1.0 : 0.0;
                    if (value == 0.0) {
                        ++counter;
                    }
                    ++i;
                }
                dataRow[((double[])dataRow).length - 1] = (double)counter < sparseFraction * (double)numberOfAttributes ? (Object)label.getMapping().mapString("positive") : (Object)label.getMapping().mapString("negative");
                table.addDataRow(new DoubleArrayDataRow((double[])dataRow));
            }
            ++n;
        }
        ExampleSet result = table.createExampleSet(label);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_ATTRIBUTES, "The number of attributes.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_SPARSE_FRACTION, "The fraction of default attributes.", 0.0, 1.0, 0.99));
        types.add(new ParameterTypeBoolean(PARAMETER_SPARSE_REPRESENTATION, "Indicates if the example should be internally represented in a sparse format.", true));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

