/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLabelGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_REGRESSION = "regression";
    public static final String PARAMETER_ATTRIBUTES_LOWER_BOUND = "attributes_lower_bound";
    public static final String PARAMETER_ATTRIBUTES_UPPER_BOUND = "attributes_upper_bound";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final int NUMBER_OF_ATTRIBUTES = 5;

    public MultipleLabelGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        double lower = this.getParameterAsDouble(PARAMETER_ATTRIBUTES_LOWER_BOUND);
        double upper = this.getParameterAsDouble(PARAMETER_ATTRIBUTES_UPPER_BOUND);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int m = 0;
        while (m < 5) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
            ++m;
        }
        int type = 1;
        if (this.getParameterAsBoolean(PARAMETER_REGRESSION)) {
            type = 4;
        }
        Attribute label1 = AttributeFactory.createAttribute("label1", type);
        attributes.add(label1);
        Attribute label2 = AttributeFactory.createAttribute("label2", type);
        attributes.add(label2);
        Attribute label3 = AttributeFactory.createAttribute("label3", type);
        attributes.add(label3);
        if (!this.getParameterAsBoolean(PARAMETER_REGRESSION)) {
            label1.getMapping().mapString("positive");
            label1.getMapping().mapString("negative");
            label2.getMapping().mapString("positive");
            label2.getMapping().mapString("negative");
            label3.getMapping().mapString("positive");
            label3.getMapping().mapString("negative");
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        LinkedList<DoubleArrayDataRow> data = new LinkedList<DoubleArrayDataRow>();
        int n = 0;
        while (n < numberOfExamples) {
            double[] features = new double[5];
            int i = 0;
            while (i < features.length) {
                features[i] = random.nextDoubleInRange(lower, upper);
                ++i;
            }
            double[] example = new double[8];
            System.arraycopy(features, 0, example, 0, features.length);
            if (this.getParameterAsBoolean(PARAMETER_REGRESSION)) {
                example[example.length - 3] = example[0] + example[1] + example[2];
                example[example.length - 2] = 2.0 * example[0] + example[3];
                example[example.length - 1] = example[3] * example[3];
            } else {
                example[example.length - 3] = example[0] + example[1] + example[2] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
                example[example.length - 2] = 2.0 * example[0] + example[3] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
                example[example.length - 1] = example[3] * example[3] - example[2] * example[2] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
            }
            data.add(new DoubleArrayDataRow(example));
            ++n;
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(label1, "label1");
        specialMap.put(label2, "label2");
        specialMap.put(label3, "label3");
        ExampleSet result = table.createExampleSet(specialMap);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REGRESSION, "Defines if multiple labels for regression tasks should be generated.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_ATTRIBUTES_LOWER_BOUND, "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble(PARAMETER_ATTRIBUTES_UPPER_BOUND, "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

