/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConstructionsWriter
extends Operator {
    public static final String PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE = "attribute_constructions_file";
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public AttributeConstructionsWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File generatorFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, true);
        ExampleSet eSet = this.getInput(ExampleSet.class);
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(generatorFile));
                out.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
                out.println("<constructions version=\"" + RapidMiner.getShortVersion() + "\">");
                for (Attribute attribute : eSet.getAttributes()) {
                    out.println("    <attribute name=\"" + attribute.getName() + "\" construction=\"" + attribute.getConstruction() + "\"/>");
                }
                out.println("</constructions>");
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, generatorFile, e.getMessage());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, "Filename for the attribute construction description file.", "att", false));
        return types;
    }
}

