/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeightsLoader
extends AbstractReader<AttributeWeights> {
    public static final String PARAMETER_ATTRIBUTE_WEIGHTS_FILE = "attribute_weights_file";

    public AttributeWeightsLoader(OperatorDescription description) {
        super(description, AttributeWeights.class);
    }

    @Override
    public AttributeWeights read() throws OperatorException {
        File weightFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_WEIGHTS_FILE);
        AttributeWeights result = null;
        try {
            result = AttributeWeights.load(weightFile);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, weightFile, e.getMessage());
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_WEIGHTS_FILE, "Filename of the attribute weights file.", "wgt", false));
        return types;
    }
}

