/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C45ExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_C45_FILESTEM = "c45_filestem";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";

    public C45ExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_C45_FILESTEM);
        Attribute label = AttributeFactory.createAttribute("label", 1);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        File nameFile = this.getFile(file, "names");
        BufferedReader in = null;
        Pattern separatorPattern = Pattern.compile(",");
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nameFile), this.getEncoding()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    Object possibleValuesString;
                    int valueType;
                    int commentIndex = (line = line.trim()).indexOf("|");
                    if (commentIndex >= 0) {
                        line = line.substring(0, commentIndex).trim();
                    }
                    if (line.length() > 0 && line.charAt(line.length() - 1) == '.') {
                        line = line.substring(0, line.length() - 1).trim();
                    }
                    if (line.length() == 0) continue;
                    int colonIndex = line.indexOf(":");
                    if (colonIndex >= 0) {
                        String attributeName = line.substring(0, colonIndex).trim();
                        String typeString = line.substring(colonIndex + 1).trim();
                        valueType = 1;
                        if (typeString.equals("continuous")) {
                            valueType = 4;
                        }
                        Attribute attribute = AttributeFactory.createAttribute(attributeName, valueType);
                        if (valueType == 1 && !typeString.equals("discrete")) {
                            String[] possibleValues;
                            possibleValuesString = typeString;
                            String[] stringArray = possibleValues = Tools.quotedSplit((String)possibleValuesString, separatorPattern);
                            int n = possibleValues.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                attribute.getMapping().mapString(s.trim());
                                ++n2;
                            }
                        }
                        attributes.add(attribute);
                        continue;
                    }
                    String[] possibleClasses = line.split(",");
                    possibleValuesString = possibleClasses = Tools.quotedSplit(line, separatorPattern);
                    int attribute = possibleClasses.length;
                    valueType = 0;
                    while (valueType < attribute) {
                        String s = possibleValuesString[valueType];
                        label.getMapping().mapString(s.trim());
                        ++valueType;
                    }
                }
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, nameFile, e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + file);
                }
            }
        }
        attributes.add(label);
        File dataFile = this.getFile(file, "data");
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), this.getEncoding()));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 301, dataFile);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0));
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        try {
            int lineCounter = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++lineCounter;
                int commentIndex = (line = line.trim()).indexOf("|");
                if (commentIndex >= 0) {
                    line = line.substring(0, commentIndex).trim();
                }
                if (line.length() > 0 && line.charAt(line.length() - 1) == '.') {
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() == 0) continue;
                String[] tokens = Tools.quotedSplit(line, separatorPattern);
                if (tokens.length != attributes.size()) {
                    in.close();
                    throw new UserError((Operator)this, 302, file, "Line " + lineCounter + ": the number of tokens in each line must be the same as the number of attributes (" + attributes.size() + "), was: " + tokens.length);
                }
                DataRow row = factory.create(tokens, attributeArray);
                table.addDataRow(row);
            }
            in.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, nameFile, e.getMessage());
        }
        return table.createExampleSet(label);
    }

    private File getFile(File file, String extension) {
        String name = file.getName();
        String fileStem = null;
        fileStem = name.indexOf(46) < 0 ? name : name.substring(0, name.lastIndexOf(46));
        return new File(String.valueOf(file.getParent()) + File.separator + fileStem + "." + extension);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_C45_FILESTEM, "The path to either the C4.5 names file, the data file, or the filestem (without extensions). Both files must be in the same directory.", null, false));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        return types;
    }
}

