/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_CSV_FILE = "csv_file";
    public static final String PARAMETER_COLUMN_SEPARATOR = "column_separator";
    public static final String PARAMETER_WRITE_ATTRIBUTE_NAMES = "write_attribute_names";
    public static final String PARAMETER_QUOTE_NOMINAL_VALUES = "quote_nominal_values";

    public CSVExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        String columnSeparator = this.getParameterAsString(PARAMETER_COLUMN_SEPARATOR);
        File file = this.getParameterAsFile(PARAMETER_CSV_FILE, true);
        boolean quoteNominalValues = this.getParameterAsBoolean(PARAMETER_QUOTE_NOMINAL_VALUES);
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding()));
                if (this.getParameterAsBoolean(PARAMETER_WRITE_ATTRIBUTE_NAMES)) {
                    Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
                    boolean first = true;
                    while (a.hasNext()) {
                        if (!first) {
                            out.print(columnSeparator);
                        }
                        Attribute attribute = a.next();
                        String name = attribute.getName();
                        if (quoteNominalValues) {
                            name = name.replaceAll("\"", "'");
                            name = "\"" + name + "\"";
                        }
                        out.print(name);
                        first = false;
                    }
                    out.println();
                }
                for (Example example : exampleSet) {
                    Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
                    boolean first = true;
                    while (a.hasNext()) {
                        Attribute attribute = a.next();
                        if (!first) {
                            out.print(columnSeparator);
                        }
                        if (!Double.isNaN(example.getValue(attribute))) {
                            if (attribute.isNominal()) {
                                String stringValue = example.getValueAsString(attribute);
                                if (quoteNominalValues) {
                                    stringValue = stringValue.replaceAll("\"", "'");
                                    stringValue = "\"" + stringValue + "\"";
                                }
                                out.print(stringValue);
                            } else {
                                out.print(example.getValue(attribute));
                            }
                        }
                        first = false;
                    }
                    out.println();
                }
            }
            catch (FileNotFoundException e) {
                throw new UserError((Operator)this, 301, file.getName());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_CSV_FILE, "The CSV file which should be written.", "csv", false));
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATOR, "The column separator.", ";"));
        types.add(new ParameterTypeBoolean(PARAMETER_WRITE_ATTRIBUTE_NAMES, "Indicates if the attribute names should be written as first row.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_QUOTE_NOMINAL_VALUES, "Indicates if nominal values should be quoted with double quotes.", true));
        return types;
    }
}

