/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.att.AttributeDataSourceCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_EXCEL_FILE = "excel_file";
    public static final String PARAMETER_SHEET_NUMBER = "sheet_number";
    public static final String PARAMETER_FIRST_ROW_AS_NAMES = "first_row_as_names";
    public static final String PARAMETER_LABEL_COLUMN = "label_column";
    public static final String PARAMETER_ID_COLUMN = "id_column";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_COLUMN_OFFSET = "column_offset";
    public static final String PARAMETER_ROW_OFFSET = "row_offset";
    public static final String PARAMETER_CREATE_LABEL = "create_label";
    public static final String PARAMETER_CREATE_ID = "create_id";

    public ExcelExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        Cell cell;
        InputStream inputStream;
        try {
            inputStream = this.getParameterAsInputStream(PARAMETER_EXCEL_FILE);
        }
        catch (IOException e1) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_EXCEL_FILE), e1.getMessage());
        }
        Workbook workbook = null;
        try {
            workbook = Workbook.getWorkbook((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_EXCEL_FILE), e.getMessage());
        }
        Sheet sheet = workbook.getSheet(this.getParameterAsInt(PARAMETER_SHEET_NUMBER) - 1);
        int numberOfColumns = sheet.getColumns();
        int numberOfRows = sheet.getRows();
        int rowOffset = this.getParameterAsInt(PARAMETER_ROW_OFFSET);
        int columnOffset = this.getParameterAsInt(PARAMETER_COLUMN_OFFSET);
        boolean contentFound = false;
        int r = rowOffset;
        while (r < numberOfRows) {
            int c = columnOffset;
            while (c < numberOfColumns) {
                Cell cell2 = sheet.getCell(c, r);
                String content = cell2.getContents();
                if (content != null && content.trim().length() > 0) {
                    columnOffset = c;
                    contentFound = true;
                    break;
                }
                ++c;
            }
            if (contentFound) {
                rowOffset = r;
                break;
            }
            ++r;
        }
        if (!contentFound) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_EXCEL_FILE), "spreadsheet seems to be empty");
        }
        TreeSet<Integer> emptyRows = new TreeSet<Integer>();
        int r2 = rowOffset;
        while (r2 < numberOfRows) {
            boolean rowEmpty = true;
            int c = columnOffset;
            while (c < numberOfColumns) {
                Cell cell3 = sheet.getCell(c, r2);
                String content = cell3.getContents();
                if (content != null && content.trim().length() > 0) {
                    rowEmpty = false;
                    break;
                }
                ++c;
            }
            if (rowEmpty) {
                emptyRows.add(r2);
            }
            ++r2;
        }
        TreeSet<Integer> emptyColumns = new TreeSet<Integer>();
        int c = columnOffset;
        while (c < numberOfColumns) {
            boolean columnEmpty = true;
            int r3 = rowOffset;
            while (r3 < numberOfRows) {
                cell = sheet.getCell(c, r3);
                String content = cell.getContents();
                if (content != null && content.trim().length() > 0) {
                    columnEmpty = false;
                    break;
                }
                ++r3;
            }
            if (columnEmpty) {
                emptyColumns.add(c);
            }
            ++c;
        }
        String[] attributeNames = new String[numberOfColumns - columnOffset - emptyColumns.size()];
        if (this.getParameterAsBoolean(PARAMETER_FIRST_ROW_AS_NAMES)) {
            int columnCounter = 0;
            int c2 = columnOffset;
            while (c2 < numberOfColumns) {
                if (!emptyColumns.contains(c2)) {
                    cell = sheet.getCell(c2, rowOffset);
                    attributeNames[columnCounter++] = cell.getContents();
                }
                ++c2;
            }
        } else {
            int c3 = 0;
            while (c3 < numberOfColumns - columnOffset - emptyColumns.size()) {
                String streamName = this.getParameter(PARAMETER_EXCEL_FILE);
                if (streamName.indexOf(46) >= 0) {
                    streamName.substring(streamName.lastIndexOf(46) + 1);
                }
                attributeNames[c3] = String.valueOf(streamName) + " (" + (c3 + 1) + ")";
                ++c3;
            }
        }
        String decimalPointCharacterString = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER);
        if (decimalPointCharacterString == null || decimalPointCharacterString.length() != 1) {
            throw new UserError((Operator)this, 216, PARAMETER_DECIMAL_POINT_CHARACTER, this.getName());
        }
        char decimalPointCharacter = decimalPointCharacterString.charAt(0);
        int[] valueTypes = new int[numberOfColumns - columnOffset - emptyColumns.size()];
        boolean[] onlyMissing = new boolean[valueTypes.length];
        int i = 0;
        while (i < valueTypes.length) {
            valueTypes[i] = 3;
            onlyMissing[i] = true;
            ++i;
        }
        int r4 = rowOffset;
        while (r4 < numberOfRows) {
            if (!(r4 == rowOffset && this.getParameterAsBoolean(PARAMETER_FIRST_ROW_AS_NAMES) || emptyRows.contains(r4))) {
                String[] row = new String[numberOfColumns - columnOffset - emptyColumns.size()];
                int columnCounter = 0;
                int c4 = columnOffset;
                while (c4 < numberOfColumns) {
                    if (!emptyColumns.contains(c4)) {
                        Cell cell4 = sheet.getCell(c4, r4);
                        row[columnCounter] = cell4.getContents();
                        if (row[columnCounter] == null || row[columnCounter].trim().length() == 0) {
                            row[columnCounter] = "?";
                        }
                        ++columnCounter;
                    }
                    ++c4;
                }
                AttributeDataSourceCreator.guessValueTypes(row, valueTypes, onlyMissing, decimalPointCharacter);
            }
            ++r4;
        }
        int m = 0;
        while (m < onlyMissing.length) {
            if (onlyMissing[m]) {
                valueTypes[m] = 1;
            }
            ++m;
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int c5 = 0;
        while (c5 < numberOfColumns - columnOffset - emptyColumns.size()) {
            attributes.add(AttributeFactory.createAttribute(attributeNames[c5], valueTypes[c5]));
            ++c5;
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory dataRowFactory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), decimalPointCharacter);
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        int r5 = rowOffset;
        while (r5 < numberOfRows) {
            if (!(r5 == rowOffset && this.getParameterAsBoolean(PARAMETER_FIRST_ROW_AS_NAMES) || emptyRows.contains(r5))) {
                String[] row = new String[numberOfColumns - columnOffset - emptyColumns.size()];
                int columnCounter = 0;
                int c6 = columnOffset;
                while (c6 < numberOfColumns) {
                    if (!emptyColumns.contains(c6)) {
                        Cell cell5 = sheet.getCell(c6, r5);
                        row[columnCounter] = cell5.getContents();
                        if (row[columnCounter] == null || row[columnCounter].trim().length() == 0) {
                            row[columnCounter] = "?";
                        }
                        ++columnCounter;
                    }
                    ++c6;
                }
                DataRow dataRow = dataRowFactory.create(row, attributeArray);
                table.addDataRow(dataRow);
                this.checkForStop();
            }
            ++r5;
        }
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        if (this.getParameterAsBoolean(PARAMETER_CREATE_LABEL)) {
            Attribute labelAttribute = null;
            int labelColumn = this.getParameterAsInt(PARAMETER_LABEL_COLUMN);
            if (labelColumn >= attributes.size() + 1) {
                throw new UserError((Operator)this, 111, "label_column = " + labelColumn);
            }
            labelAttribute = attributeArray[labelColumn - 1];
            specialMap.put(labelAttribute, "label");
        }
        if (this.getParameterAsBoolean(PARAMETER_CREATE_ID)) {
            Attribute idAttribute = null;
            int idColumn = this.getParameterAsInt(PARAMETER_ID_COLUMN);
            if (idColumn >= attributes.size() + 1) {
                throw new UserError((Operator)this, 111, "id_column = " + idColumn);
            }
            idAttribute = attributeArray[idColumn - 1];
            specialMap.put(idAttribute, "id");
        }
        ExampleSet exampleSet = table.createExampleSet(specialMap);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_EXCEL_FILE, "The Excel spreadsheet file which should be loaded.", "xls", false));
        types.add(new ParameterTypeInt(PARAMETER_SHEET_NUMBER, "The number of the sheet which should be imported.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_ROW_OFFSET, "The number of rows to skip at top of sheet as they contain no usable data.", 0, 65535, 0));
        types.add(new ParameterTypeInt(PARAMETER_COLUMN_OFFSET, "The number of columns to skip at left side of sheet as they contain no usable data.", 0, 255, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_FIRST_ROW_AS_NAMES, "Indicates if the first row should be used for the attribute names.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_LABEL, "Indicates if the sheet has a label column.", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_LABEL_COLUMN, "Indicates which column should be used for the label attribute", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_CREATE_LABEL, false, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_ID, "Indicates if sheet has a id column.", false));
        type = new ParameterTypeInt(PARAMETER_ID_COLUMN, "Indicates which column should be used for the Id attribute", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_CREATE_ID, false, true));
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

