/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractModelLoader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelLoader
extends AbstractModelLoader {
    public static final String PARAMETER_MODEL_FILE = "model_file";

    public ModelLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model read() throws OperatorException {
        File modelFile = this.getParameterAsFile(PARAMETER_MODEL_FILE);
        Model model = null;
        try {
            ObjectInputStream objectIn = new ObjectInputStream(new FileInputStream(modelFile));
            model = (Model)objectIn.readObject();
            objectIn.close();
        }
        catch (Exception e) {
            InputStream in = null;
            try {
                in = new GZIPInputStream(new FileInputStream(modelFile));
            }
            catch (IOException e1) {
                try {
                    in = new FileInputStream(modelFile);
                }
                catch (IOException e2) {
                    throw new UserError((Operator)this, (Throwable)e, 302, modelFile, e2.getMessage());
                }
            }
            try {
                model = (Model)AbstractIOObject.read(in);
                in.close();
            }
            catch (IOException e3) {
                throw new UserError((Operator)this, (Throwable)e, 302, modelFile, e3.getMessage());
            }
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_MODEL_FILE, "Filename containing the model to load.", "mod", false));
        return types;
    }
}

