/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.ResultService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultWriter
extends Operator {
    public static final String PARAMETER_RESULT_FILE = "result_file";
    private boolean firstRun = true;

    public ResultWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOObject[] input = this.getInput().getIOObjects();
        File file = this.getParameterAsFile(PARAMETER_RESULT_FILE, true);
        if (file != null) {
            PrintWriter out = null;
            try {
                out = this.firstRun ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), this.getEncoding())) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), this.getEncoding()));
                this.firstRun = false;
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 301, file);
            }
            ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ", out);
            int i = 0;
            while (i < input.length) {
                if (input[i] instanceof ResultObject) {
                    ResultService.logResult((ResultObject)input[i], out);
                }
                ++i;
            }
            out.close();
        } else {
            ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ");
            int i = 0;
            while (i < input.length) {
                if (input[i] instanceof ResultObject) {
                    ResultService.logResult((ResultObject)input[i]);
                }
                ++i;
            }
        }
        return new IOObject[0];
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        this.firstRun = true;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_RESULT_FILE, "Appends the descriptions of the input objects to this file. If empty, use the general file defined in the process root operator.", "res", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

