/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;

public abstract class SimpleBinaryPredictionModel
extends PredictionModel {
    private static final long serialVersionUID = 1540861516979781090L;
    private double threshold = 0.0;

    protected SimpleBinaryPredictionModel(ExampleSet exampleSet, double threshold) {
        super(exampleSet);
        this.threshold = threshold;
    }

    public abstract double predict(Example var1) throws OperatorException;

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        if (!predictedLabel.isNominal()) {
            throw new UserError(null, 101, this.getName(), predictedLabel.getName());
        }
        if (predictedLabel.getMapping().getValues().size() != 2) {
            throw new UserError(null, 114, this.getName(), predictedLabel.getName());
        }
        for (Example example : exampleSet) {
            double functionValue = this.predict(example) - this.threshold;
            if (functionValue > 0.0) {
                example.setValue(predictedLabel, this.getLabel().getMapping().getPositiveIndex());
            } else {
                example.setValue(predictedLabel, this.getLabel().getMapping().getNegativeIndex());
            }
            example.setConfidence(this.getLabel().getMapping().mapIndex(predictedLabel.getMapping().getPositiveIndex()), 1.0 / (1.0 + Math.exp(-functionValue)));
            example.setConfidence(this.getLabel().getMapping().mapIndex(predictedLabel.getMapping().getNegativeIndex()), 1.0 / (1.0 + Math.exp(functionValue)));
        }
        return exampleSet;
    }
}

