/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.functions.PolynomialRegressionModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialRegression
extends AbstractLearner {
    private static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    private static final String PARAMETER_REPLICATION_FACTOR = "replication_factor";
    private static final String PARAMETER_MAX_DEGREE = "max_degree";
    private static final String PARAMETER_MIN_COEFFICIENT = "min_coefficient";
    private static final String PARAMETER_MAX_COEFFICIENT = "max_coefficient";
    private static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public PolynomialRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        RegressionOptimization optimization = new RegressionOptimization(exampleSet, this.getParameterAsInt(PARAMETER_REPLICATION_FACTOR), this.getParameterAsInt(PARAMETER_MAX_ITERATIONS), this.getParameterAsInt(PARAMETER_MAX_DEGREE), this.getParameterAsDouble(PARAMETER_MIN_COEFFICIENT), this.getParameterAsDouble(PARAMETER_MAX_COEFFICIENT), RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)), this);
        optimization.optimize();
        double[] values = optimization.getBestValuesEver();
        double[][] coefficients = optimization.getCoefficients(values);
        double[][] degrees = optimization.getDegrees(values);
        double offset = optimization.getOffset(values);
        return new PolynomialRegressionModel(exampleSet, coefficients, degrees, offset);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc.equals(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        if (lc.equals(LearnerCapability.NUMERICAL_CLASS)) {
            return true;
        }
        return lc == LearnerCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "The maximum number of iterations used for model fitting.", 1, Integer.MAX_VALUE, 5000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_REPLICATION_FACTOR, "The amount of times each input variable is replicated, i.e. how many different degrees and coefficients can be applied to each variable", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_DEGREE, "The maximal degree used for the final polynomial.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_COEFFICIENT, "The minimum number used for the coefficients and the offset.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -100.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX_COEFFICIENT, "The maximum number used for the coefficients and the offset.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 100.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        types.add(type);
        return types;
    }

    private static class RegressionOptimization
    extends ESOptimization {
        private int replicationFactor;
        private ExampleSet exampleSet;
        private Attribute label;

        public RegressionOptimization(ExampleSet exampleSet, int replicationFactor, int maxIterations, int maxDegree, double minCoefficient, double maxCoefficient, RandomGenerator random, LoggingHandler logging) {
            super(RegressionOptimization.getMinVector(exampleSet, replicationFactor, minCoefficient), RegressionOptimization.getMaxVector(exampleSet, replicationFactor, maxDegree, maxCoefficient), 1, exampleSet.getAttributes().size() * 2 * replicationFactor + 1, 0, maxIterations, maxIterations, 6, 1.0, true, 1, 0.01, 0.0, false, false, random, logging);
            this.replicationFactor = replicationFactor;
            this.exampleSet = exampleSet;
            this.label = exampleSet.getAttributes().getLabel();
            int index = 0;
            int a = 0;
            while (a < exampleSet.getAttributes().size()) {
                int f = 0;
                while (f < replicationFactor) {
                    this.setValueType(index++, OptimizationValueType.VALUE_TYPE_DOUBLE);
                    this.setValueType(index++, OptimizationValueType.VALUE_TYPE_INT);
                    ++f;
                }
                ++a;
            }
            this.setValueType(exampleSet.getAttributes().size() * replicationFactor * 2, OptimizationValueType.VALUE_TYPE_DOUBLE);
        }

        private static double[] getMinVector(ExampleSet exampleSet, int replicationFactor, double minCoefficient) {
            double[] result = new double[exampleSet.getAttributes().size() * replicationFactor * 2 + 1];
            int index = 0;
            int a = 0;
            while (a < exampleSet.getAttributes().size()) {
                int f = 0;
                while (f < replicationFactor) {
                    result[index++] = minCoefficient;
                    result[index++] = 1.0;
                    ++f;
                }
                ++a;
            }
            result[result.length - 1] = minCoefficient;
            return result;
        }

        private static double[] getMaxVector(ExampleSet exampleSet, int replicationFactor, double maxDegree, double maxCoefficient) {
            double[] result = new double[exampleSet.getAttributes().size() * replicationFactor * 2 + 1];
            int index = 0;
            int a = 0;
            while (a < exampleSet.getAttributes().size()) {
                int f = 0;
                while (f < replicationFactor) {
                    result[index++] = maxCoefficient;
                    result[index++] = maxDegree;
                    ++f;
                }
                ++a;
            }
            result[result.length - 1] = maxCoefficient;
            return result;
        }

        public PerformanceVector evaluateIndividual(Individual individual) throws OperatorException {
            double[] values = individual.getValues();
            double[][] coefficients = this.getCoefficients(values);
            double[][] degrees = this.getDegrees(values);
            double offset = this.getOffset(values);
            double error = 0.0;
            for (Example example : this.exampleSet) {
                double prediction = PolynomialRegressionModel.calculatePrediction(example, coefficients, degrees, offset);
                double diff = Math.abs(example.getValue(this.label) - prediction);
                error += diff * diff;
            }
            error = Math.sqrt(error);
            PerformanceVector performanceVector = new PerformanceVector();
            performanceVector.addCriterion(new EstimatedPerformance("Polynomial Regression Error", error, 1, true));
            return performanceVector;
        }

        public double[][] getCoefficients(double[] values) {
            int attSize = this.exampleSet.getAttributes().size();
            double[][] coefficients = new double[this.replicationFactor][attSize];
            int f = 0;
            while (f < this.replicationFactor) {
                int a = 0;
                while (a < attSize) {
                    coefficients[f][a] = values[f * attSize * 2 + a * 2];
                    ++a;
                }
                ++f;
            }
            return coefficients;
        }

        public double[][] getDegrees(double[] values) {
            int attSize = this.exampleSet.getAttributes().size();
            double[][] degrees = new double[this.replicationFactor][attSize];
            int f = 0;
            while (f < this.replicationFactor) {
                int a = 0;
                while (a < attSize) {
                    degrees[f][a] = values[f * attSize * 2 + a * 2 + 1];
                    ++a;
                }
                ++f;
            }
            return degrees;
        }

        public double getOffset(double[] values) {
            return values[values.length - 1];
        }
    }
}

