/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public class GSSModel
extends PredictionModel {
    private static final long serialVersionUID = -9210831626413275099L;
    protected Hypothesis hypothesis;
    protected double[] confidences;
    protected static Attribute[] regularAttributes;
    protected boolean crisp = true;

    public GSSModel(ExampleSet exampleSet, Hypothesis hypothesis, double[] confidences) {
        super(exampleSet);
        this.hypothesis = hypothesis.clone();
        this.confidences = new double[2];
        this.confidences[0] = confidences[0];
        this.confidences[1] = confidences[1];
    }

    public boolean equals(Object o) {
        if (!(o instanceof GSSModel)) {
            return false;
        }
        GSSModel otherModel = (GSSModel)o;
        return otherModel.hypothesis.equals(this.hypothesis);
    }

    public int hashCode() {
        return this.hypothesis.hashCode();
    }

    public int getPredictionIndex() {
        if (this.confidences[1] >= this.confidences[0]) {
            return 1;
        }
        return 0;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        boolean worstPrediction;
        boolean bestPrediction;
        Iterator reader = exampleSet.iterator();
        if (this.confidences[1] >= this.confidences[0]) {
            bestPrediction = true;
            worstPrediction = false;
        } else {
            bestPrediction = false;
            worstPrediction = true;
        }
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            if (this.applicable(e)) {
                e.setValue(predictedLabel, (double)bestPrediction);
            } else {
                e.setValue(predictedLabel, (double)worstPrediction);
            }
            e.setConfidence(this.getLabel().getMapping().mapIndex(0), this.confidences[0]);
            e.setConfidence(this.getLabel().getMapping().mapIndex(1), this.confidences[1]);
        }
        return exampleSet;
    }

    public boolean applicable(Example example) {
        return this.hypothesis.applicable(example);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(Tools.getLineSeparator());
        result.append(this.hypothesis);
        return result.toString();
    }

    public Hypothesis getHypothesis() {
        return this.hypothesis;
    }
}

