/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.Iterator;

public class AdditiveRegressionModel
extends PredictionModel {
    private static final long serialVersionUID = -8036434608645810089L;
    private Model defaultModel;
    private Model[] residualModels;
    private double shrinkage;

    public AdditiveRegressionModel(ExampleSet exampleSet, Model defaultModel, Model[] residualModels, double shrinkage) {
        super(exampleSet);
        this.defaultModel = defaultModel;
        this.residualModels = residualModels;
        this.shrinkage = shrinkage;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        exampleSet = this.defaultModel.apply(exampleSet);
        double[] predictions = new double[exampleSet.size()];
        Iterator e = exampleSet.iterator();
        int counter = 0;
        while (e.hasNext()) {
            predictions[counter++] = ((Example)e.next()).getPredictedLabel();
        }
        PredictionModel.removePredictedLabel(exampleSet);
        int i = 0;
        while (i < this.residualModels.length) {
            exampleSet = this.residualModels[i].apply(exampleSet);
            e = exampleSet.iterator();
            counter = 0;
            while (e.hasNext()) {
                int n = counter++;
                predictions[n] = predictions[n] + this.shrinkage * ((Example)e.next()).getPredictedLabel();
            }
            PredictionModel.removePredictedLabel(exampleSet);
            ++i;
        }
        e = exampleSet.iterator();
        counter = 0;
        Attribute newPredictedLabel = AdditiveRegressionModel.createPredictedLabel(exampleSet, this.getLabel());
        while (e.hasNext()) {
            ((Example)e.next()).setValue(newPredictedLabel, predictions[counter++]);
        }
        return exampleSet;
    }

    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        tabPane.add("Default Model", this.defaultModel.getVisualizationComponent(container));
        int index = 1;
        Model[] modelArray = this.residualModels;
        int n = this.residualModels.length;
        int n2 = 0;
        while (n2 < n) {
            Model residualModel = modelArray[n2];
            tabPane.add("Model " + index, residualModel.getVisualizationComponent(container));
            ++index;
            ++n2;
        }
        return tabPane;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("Default model:" + Tools.getLineSeparator() + this.defaultModel.toString() + Tools.getLineSeparator() + Tools.getLineSeparator());
        result.append("Number of base models: " + this.residualModels.length + Tools.getLineSeparator());
        result.append("Shrinkage: " + this.shrinkage + Tools.getLineSeparator());
        int i = 0;
        while (i < this.residualModels.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + Tools.ordinalNumber(i + 1) + " Model:" + Tools.getLineSeparator() + this.residualModels[i] + Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }
}

