/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;
import com.rapidminer.operator.learner.tree.InfoGainCriterion;

public class GainRatioCriterion
extends InfoGainCriterion {
    private static double LOG_FACTOR = 1.0 / Math.log(2.0);
    private FrequencyCalculator frequencyCalculator = new FrequencyCalculator();

    public GainRatioCriterion() {
    }

    public GainRatioCriterion(double minimalGain) {
        super(minimalGain);
    }

    public double getNominalBenefit(ExampleSet exampleSet, Attribute attribute) {
        double[][] weightCounts = this.frequencyCalculator.getNominalWeightCounts(exampleSet, attribute);
        double gain = this.getBenefit(weightCounts);
        double splitInfo = this.getSplitInfo(weightCounts);
        if (splitInfo == 0.0) {
            return gain;
        }
        return gain / splitInfo;
    }

    public double getNumericalBenefit(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        double[][] weightCounts = this.frequencyCalculator.getNumericalWeightCounts(exampleSet, attribute, splitValue);
        double gain = this.getBenefit(weightCounts);
        double splitInfo = this.getSplitInfo(weightCounts);
        if (splitInfo == 0.0) {
            return gain;
        }
        return gain / splitInfo;
    }

    protected double getSplitInfo(double[][] weightCounts) {
        double[] splitCounts = new double[weightCounts.length];
        int v = 0;
        while (v < weightCounts.length) {
            int l = 0;
            while (l < weightCounts[v].length) {
                int n = v;
                splitCounts[n] = splitCounts[n] + weightCounts[v][l];
                ++l;
            }
            ++v;
        }
        double totalSplitCount = 0.0;
        double[] dArray = splitCounts;
        int n = splitCounts.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            totalSplitCount += w;
            ++n2;
        }
        double splitInfo = 0.0;
        int v2 = 0;
        while (v2 < splitCounts.length) {
            if (splitCounts[v2] > 0.0) {
                double proportion = splitCounts[v2] / totalSplitCount;
                splitInfo -= Math.log(proportion) * LOG_FACTOR * proportion;
            }
            ++v2;
        }
        return splitInfo;
    }

    protected double getSplitInfo(double[] partitionWeights, double totalWeight) {
        double splitInfo = 0.0;
        double[] dArray = partitionWeights;
        int n = partitionWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double partitionWeight = dArray[n2];
            if (partitionWeight > 0.0) {
                double partitionProportion = partitionWeight / totalWeight;
                splitInfo += partitionProportion * Math.log(partitionProportion) * LOG_FACTOR;
            }
            ++n2;
        }
        return -splitInfo;
    }

    public boolean supportsIncrementalCalculation() {
        return true;
    }

    public double getIncrementalBenefit() {
        double gain = this.getEntropy(this.totalLabelWeights, this.totalWeight);
        gain -= this.getEntropy(this.leftLabelWeights, this.leftWeight) * this.leftWeight / this.totalWeight;
        gain -= this.getEntropy(this.rightLabelWeights, this.rightWeight) * this.rightWeight / this.totalWeight;
        double splitInfo = this.getSplitInfo(new double[]{this.leftWeight, this.rightWeight}, this.totalWeight);
        if (splitInfo == 0.0) {
            return gain;
        }
        return gain / splitInfo;
    }
}

