/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.tree.DecisionTreeLearner;
import com.rapidminer.operator.learner.tree.RandomSubsetPreprocessing;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTreeLearner
extends DecisionTreeLearner {
    public static final String PARAMETER_SUBSET_RATIO = "subset_ratio";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public RandomTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public SplitPreprocessing getSplitPreprocessing() {
        RandomSubsetPreprocessing preprocessing = null;
        try {
            preprocessing = new RandomSubsetPreprocessing(this.getParameterAsDouble(PARAMETER_SUBSET_RATIO), RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return preprocessing;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SUBSET_RATIO, "Ratio of randomly chosen attributes to test (-1: use log(m) + 1 features)", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

