/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.meta.ParameterValue;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSet
extends ResultObjectAdapter {
    private static final long serialVersionUID = -2615523039124583537L;
    private static final String RESULT_ICON_NAME = "preferences.png";
    private static Icon resultIcon = null;
    private List<ParameterValue> parameterValues = new LinkedList<ParameterValue>();
    private PerformanceVector performance;

    static {
        resultIcon = SwingTools.createIcon("16/preferences.png");
    }

    private ParameterSet() {
    }

    public ParameterSet(Operator[] operators, String[] parameters, String[] values, PerformanceVector value) {
        if (operators.length != parameters.length || operators.length != values.length) {
            throw new IllegalArgumentException("The arrays operators, parameters, and values must be of equal size!");
        }
        int i = 0;
        while (i < operators.length) {
            this.parameterValues.add(new ParameterValue(operators[i].getName(), parameters[i], values[i]));
            ++i;
        }
        this.performance = value;
    }

    @Override
    public String getName() {
        return "ParameterSet";
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Parameter set:" + Tools.getLineSeparator());
        str.append(String.valueOf(Tools.getLineSeparator()) + "Performance: " + this.performance + Tools.getLineSeparator());
        Iterator<ParameterValue> i = this.parameterValues.iterator();
        while (i.hasNext()) {
            str.append(String.valueOf(((Object)i.next()).toString()) + Tools.getLineSeparator());
        }
        return str.toString();
    }

    public PerformanceVector getPerformance() {
        return this.performance;
    }

    public void applyAll(Process process, Map<String, String> nameMap) {
        Iterator<ParameterValue> i = this.parameterValues.iterator();
        while (i.hasNext()) {
            i.next().apply(process, nameMap);
        }
    }

    @Override
    public void save(File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            this.writeParameterSet(out, Tools.getDefaultEncoding());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public String getExtension() {
        return "par";
    }

    @Override
    public String getFileDescription() {
        return "parameter set file";
    }

    public Iterator<ParameterValue> getParameterValues() {
        return this.parameterValues.iterator();
    }

    public void writeParameterSet(PrintWriter out, Charset encoding) {
        out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        out.println("<parameterset version=\"" + RapidMiner.getShortVersion() + "\">");
        for (ParameterValue value : this.parameterValues) {
            out.println("    <parameter operator=\"" + value.getOperator() + "\" key=\"" + value.getParameterKey() + "\" value=\"" + value.getParameterValue() + "\"/>");
        }
        out.println("</parameterset>");
    }

    public static ParameterSet readParameterSet(InputStream in) throws IOException {
        ParameterSet parameterSet = new ParameterSet();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element parametersElement = document.getDocumentElement();
        if (!parametersElement.getTagName().equals("parameterset")) {
            throw new IOException("Outer tag of parameter set file must be <parameterset>");
        }
        NodeList parameters = parametersElement.getChildNodes();
        int i = 0;
        while (i < parameters.getLength()) {
            Node node = parameters.item(i);
            if (node instanceof Element) {
                Element parameterTag = (Element)node;
                String tagName = parameterTag.getTagName();
                if (!tagName.equals("parameter")) {
                    throw new IOException("Only tags <parameter> are allowed, was " + tagName);
                }
                String operatorName = parameterTag.getAttribute("operator");
                String parameterKey = parameterTag.getAttribute("key");
                String parameterValue = parameterTag.getAttribute("value");
                parameterSet.parameterValues.add(new ParameterValue(operatorName, parameterKey, parameterValue));
            }
            ++i;
        }
        return parameterSet;
    }

    @Override
    public Icon getResultIcon() {
        return resultIcon;
    }
}

