/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatUntilOperatorChain
extends OperatorChain {
    public static final String PARAMETER_MIN_ATTRIBUTES = "min_attributes";
    public static final String PARAMETER_MAX_ATTRIBUTES = "max_attributes";
    public static final String PARAMETER_MIN_EXAMPLES = "min_examples";
    public static final String PARAMETER_MAX_EXAMPLES = "max_examples";
    public static final String PARAMETER_MIN_CRITERION = "min_criterion";
    public static final String PARAMETER_MAX_CRITERION = "max_criterion";
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_TIMEOUT = "timeout";
    public static final String PARAMETER_PERFORMANCE_CHANGE = "performance_change";
    public static final String PARAMETER_CONDITION_BEFORE = "condition_before";
    public static final String[] COMPARISONS = new String[]{"none", "decreasing", "non-increasing"};
    public static final int NONE = 0;
    public static final int DECREASING = 1;
    public static final int NONINCREASING = 2;
    private int iteration;
    private long stoptime;
    private double fitness;
    private IOContainer lastInput;

    public RepeatUntilOperatorChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.iteration = 0;
        int timeout = this.getParameterAsInt(PARAMETER_TIMEOUT);
        this.stoptime = timeout == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + 60000L * (long)timeout;
        this.lastInput = null;
        this.fitness = Double.NEGATIVE_INFINITY;
        IOContainer input = this.getInput().copy();
        while (!this.evaluateCondition(input)) {
            this.log("Iteration " + this.iteration);
            int j = 0;
            while (j < this.getNumberOfOperators()) {
                input = this.getOperator(j).apply(input);
                ++j;
            }
            ++this.iteration;
            this.inApplyLoop();
        }
        if (this.lastInput != null) {
            input = this.lastInput;
        }
        return new IOObject[0];
    }

    private boolean evaluateCondition(IOContainer input) throws MissingIOObjectException, UndefinedParameterError {
        double crit;
        int nrEx;
        int nrAtts;
        int maxit;
        if (this.iteration == 0 && !this.getParameterAsBoolean(PARAMETER_CONDITION_BEFORE)) {
            return false;
        }
        int changeType = this.getParameterAsInt(PARAMETER_PERFORMANCE_CHANGE);
        if (changeType != 0) {
            if (this.iteration > 0) {
                double currentFitness = input.get(PerformanceVector.class).getMainCriterion().getFitness();
                if (changeType == 1 && currentFitness < this.fitness) {
                    return true;
                }
                if (changeType == 2 && currentFitness <= this.fitness) {
                    return true;
                }
                this.fitness = currentFitness;
            }
            this.lastInput = input.copy();
            input.remove(PerformanceVector.class);
        }
        if (this.iteration >= (maxit = this.getParameterAsInt(PARAMETER_MAX_ITERATIONS))) {
            this.log("Maximum number of iterations met.");
            return true;
        }
        if (System.currentTimeMillis() > this.stoptime) {
            this.log("Runtime exceeded.");
            return true;
        }
        int maxAtts = this.getParameterAsInt(PARAMETER_MAX_ATTRIBUTES);
        int minAtts = this.getParameterAsInt(PARAMETER_MIN_ATTRIBUTES);
        if (!(maxAtts >= Integer.MAX_VALUE && minAtts <= 0 || (nrAtts = input.get(ExampleSet.class).getAttributes().size()) <= maxAtts && nrAtts >= minAtts)) {
            return false;
        }
        int maxEx = this.getParameterAsInt(PARAMETER_MAX_EXAMPLES);
        int minEx = this.getParameterAsInt(PARAMETER_MIN_EXAMPLES);
        if (!(maxEx >= Integer.MAX_VALUE && minEx <= 0 || (nrEx = input.get(ExampleSet.class).size()) <= maxEx && nrEx >= minEx)) {
            return false;
        }
        double maxCrit = this.getParameterAsDouble(PARAMETER_MAX_CRITERION);
        double minCrit = this.getParameterAsDouble(PARAMETER_MIN_CRITERION);
        if ((maxCrit < Double.POSITIVE_INFINITY || minCrit > Double.NEGATIVE_INFINITY) && ((crit = input.get(PerformanceVector.class).getMainCriterion().getAverage()) > maxCrit || crit < minCrit)) {
            return false;
        }
        this.log("All criteria met.");
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_MIN_ATTRIBUTES, "Minimal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ATTRIBUTES, "Maximal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_EXAMPLES, "Minimal number of examples in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_EXAMPLES, "Maximal number of examples in first example set", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_CRITERION, "Minimal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX_CRITERION, "Maximal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "Maximum number of iterations", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes (-1 = no timeout)", 1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_PERFORMANCE_CHANGE, "Stop when performance of inner chain behaves like this.", COMPARISONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CONDITION_BEFORE, "Evaluate condition before inner chain is applied (true) or after?", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

