/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XVPrediction
extends OperatorChain {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_LEAVE_ONE_OUT = "leave_one_out";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final String PARAMETER_USE_LOCAL_RANDOM_SEED = "use_local_random_seed";
    private int number;
    private int iteration;

    public XVPrediction(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return XVPrediction.this.iteration;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        this.number = this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT) ? inputSet.size() : this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        this.log("Starting " + this.number + "-fold cross validation prediction");
        Attribute predictedLabel = PredictionModel.createPredictedLabel(inputSet, inputSet.getAttributes().getLabel());
        List<String> predictedLabelValues = null;
        if (predictedLabel.isNominal()) {
            predictedLabelValues = predictedLabel.getMapping().getValues();
        }
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        SplittedExampleSet splittedSet = new SplittedExampleSet(inputSet, this.number, samplingType, this.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED) ? this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED) : -1);
        this.iteration = 0;
        while (this.iteration < this.number) {
            splittedSet.selectAllSubsetsBut(this.iteration);
            IOContainer learnResult = this.getLearner().apply(new IOContainer(splittedSet));
            splittedSet.selectSingleSubset(this.iteration);
            IOContainer applyResult = this.getApplier().apply(learnResult.append(new IOObject[]{splittedSet}));
            ExampleSet predictedSet = applyResult.get(ExampleSet.class);
            int i = 0;
            while (i < splittedSet.size()) {
                Example predictedExample = predictedSet.getExample(i);
                Example inputExample = inputSet.getExample(splittedSet.getActualParentIndex(i));
                inputExample.setValue(predictedLabel, predictedExample.getPredictedLabel());
                if (predictedLabel.isNominal()) {
                    for (String s : predictedLabelValues) {
                        inputExample.setConfidence(s, predictedExample.getConfidence(s));
                    }
                }
                ++i;
            }
            this.inApplyLoop();
            ++this.iteration;
        }
        return new IOObject[]{inputSet};
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{ExampleSet.class}));
        return condition;
    }

    private Operator getLearner() {
        return this.getOperator(0);
    }

    private Operator getApplier() {
        return this.getOperator(1);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_LEAVE_ONE_OUT, "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored.", false));
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LEAVE_ONE_OUT, false, false));
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation.", SplittedExampleSet.SAMPLING_NAMES, 2));
        type = new ParameterTypeBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED, "Use a local random seed instead of global random number", false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLING_TYPE, false, 1, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Specifies the local random seed", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_LOCAL_RANDOM_SEED, false, true));
        types.add(type);
        return types;
    }
}

