/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Example;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class MinMaxCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = 1739979152946602515L;
    private MeasuredPerformance delegate;
    private double fitness = Double.POSITIVE_INFINITY;
    private double fitnessSum = 0.0;
    private double value = Double.NaN;
    private double weight = 1.0;
    private int counter = 0;

    public MinMaxCriterion() {
    }

    public MinMaxCriterion(MeasuredPerformance delegate, double weight) {
        this.delegate = delegate;
        this.weight = weight;
        if (!Double.isNaN(delegate.getFitness())) {
            this.fitness = delegate.getFitness();
            this.value = delegate.getMikroAverage();
            ++this.counter;
        }
    }

    public MinMaxCriterion(MinMaxCriterion mmc) {
        super(mmc);
        this.delegate = mmc.delegate;
        this.fitness = mmc.fitness;
        this.fitnessSum = mmc.fitnessSum;
        this.counter = mmc.counter;
        this.weight = mmc.weight;
    }

    public double getExampleCount() {
        return this.delegate.getExampleCount();
    }

    public void countExample(Example example) {
        this.delegate.countExample(example);
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public double getMikroAverage() {
        return this.weight * this.value + (1.0 - this.weight) * this.delegate.getMikroAverage();
    }

    public double getFitness() {
        return this.weight * this.fitness + (1.0 - this.weight) * (this.fitnessSum / (double)this.counter);
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable avg) {
        MinMaxCriterion mmc = (MinMaxCriterion)avg;
        double currentFitness = mmc.delegate.getFitness();
        if (currentFitness < this.fitness) {
            this.fitness = currentFitness;
            this.value = mmc.delegate.getMikroAverage();
        }
        this.fitnessSum += currentFitness;
        ++this.counter;
        this.delegate.buildAverage(mmc.delegate);
    }
}

