/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class NormalizedAbsoluteError
extends MeasuredPerformance {
    private static final long serialVersionUID = -3899005486051589953L;
    private Attribute predictedAttribute;
    private Attribute labelAttribute;
    private Attribute weightAttribute;
    private double deviationSum = 0.0;
    private double relativeSum = 0.0;
    private double trueLabelSum = 0.0;
    private double exampleCounter = 0.0;

    public NormalizedAbsoluteError() {
    }

    public NormalizedAbsoluteError(NormalizedAbsoluteError nae) {
        super(nae);
        this.deviationSum = nae.deviationSum;
        this.relativeSum = nae.relativeSum;
        this.trueLabelSum = nae.trueLabelSum;
        this.exampleCounter = nae.exampleCounter;
        this.labelAttribute = (Attribute)nae.labelAttribute.clone();
        this.predictedAttribute = (Attribute)nae.predictedAttribute.clone();
        if (nae.weightAttribute != null) {
            this.weightAttribute = (Attribute)nae.weightAttribute.clone();
        }
    }

    public String getName() {
        return "normalized_absolute_error";
    }

    public String getDescription() {
        return "The absolute error divided by the error made if the average would have been predicted.";
    }

    public double getExampleCount() {
        return this.exampleCounter;
    }

    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        if (exampleSet.size() <= 1) {
            throw new UserError(null, 919, this.getName(), "normalized absolute error can only be calculated for test sets with more than 2 examples.");
        }
        this.predictedAttribute = exampleSet.getAttributes().getPredictedLabel();
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        if (useExampleWeights) {
            this.weightAttribute = exampleSet.getAttributes().getWeight();
        }
        this.trueLabelSum = 0.0;
        this.deviationSum = 0.0;
        this.relativeSum = 0.0;
        this.exampleCounter = 0.0;
        for (Example example : exampleSet) {
            double label = example.getLabel();
            double weight = 1.0;
            if (this.weightAttribute != null) {
                weight = example.getValue(this.weightAttribute);
            }
            if (Double.isNaN(label)) continue;
            this.exampleCounter += weight;
            this.trueLabelSum += label * weight;
        }
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getValue(this.labelAttribute);
        if (!this.predictedAttribute.isNominal()) {
            plabel = example.getValue(this.predictedAttribute);
        } else {
            String labelS = example.getValueAsString(this.labelAttribute);
            plabel = example.getConfidence(labelS);
            label = 1.0;
        }
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double diff = weight * Math.abs(label - plabel);
        this.deviationSum += diff;
        double relDiff = Math.abs(weight * label - this.trueLabelSum / this.exampleCounter);
        this.relativeSum += relDiff;
    }

    public double getMikroAverage() {
        return this.deviationSum / this.relativeSum;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getFitness() {
        return -1.0 * this.getAverage();
    }

    public void buildSingleAverage(Averagable performance) {
        NormalizedAbsoluteError other = (NormalizedAbsoluteError)performance;
        this.deviationSum += other.deviationSum;
        this.relativeSum += other.relativeSum;
    }
}

