/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.AbsoluteError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.AreaUnderCurve;
import com.rapidminer.operator.performance.CorrelationCriterion;
import com.rapidminer.operator.performance.CrossEntropy;
import com.rapidminer.operator.performance.LenientRelativeError;
import com.rapidminer.operator.performance.LogisticLoss;
import com.rapidminer.operator.performance.Margin;
import com.rapidminer.operator.performance.MultiClassificationPerformance;
import com.rapidminer.operator.performance.NormalizedAbsoluteError;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PredictionAverage;
import com.rapidminer.operator.performance.PredictionTrendAccuracy;
import com.rapidminer.operator.performance.RankCorrelation;
import com.rapidminer.operator.performance.RelativeError;
import com.rapidminer.operator.performance.RootMeanSquaredError;
import com.rapidminer.operator.performance.RootRelativeSquaredError;
import com.rapidminer.operator.performance.SoftMarginLoss;
import com.rapidminer.operator.performance.SquaredCorrelationCriterion;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.operator.performance.StrictRelativeError;
import com.rapidminer.operator.performance.WeightedMultiClassPerformance;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceEvaluator
extends AbstractPerformanceEvaluator {
    public static final String PARAMETER_CLASS_WEIGHTS = "class_weights";
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{RootMeanSquaredError.class, AbsoluteError.class, RelativeError.class, LenientRelativeError.class, StrictRelativeError.class, NormalizedAbsoluteError.class, RootRelativeSquaredError.class, SquaredError.class, CorrelationCriterion.class, SquaredCorrelationCriterion.class, PredictionAverage.class, PredictionTrendAccuracy.class, AreaUnderCurve.class, CrossEntropy.class, Margin.class, SoftMarginLoss.class, LogisticLoss.class};

    public PerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        double[] weights = null;
        if (this.isParameterSet(PARAMETER_CLASS_WEIGHTS)) {
            weights = new double[label.getMapping().size()];
            int i = 0;
            while (i < weights.length) {
                weights[i] = 1.0;
                ++i;
            }
            List<String[]> classWeights = this.getParameterList(PARAMETER_CLASS_WEIGHTS);
            for (String[] classWeightArray : classWeights) {
                String className = classWeightArray[0];
                double classWeight = Double.valueOf(classWeightArray[1]);
                int index = label.getMapping().mapString(className);
                weights[index] = classWeight;
            }
            LinkedList<Double> weightList = new LinkedList<Double>();
            double[] dArray = weights;
            int n = weights.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                weightList.add(d);
                ++n2;
            }
            this.log(String.valueOf(this.getName()) + ": used class weights --> " + weightList);
        }
        return weights;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        LinkedList<PerformanceCriterion> performanceCriteria = new LinkedList<PerformanceCriterion>();
        int i = 0;
        while (i < SIMPLE_CRITERIA_CLASSES.length) {
            try {
                performanceCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            ++i;
        }
        i = 0;
        while (i < MultiClassificationPerformance.NAMES.length) {
            performanceCriteria.add(new MultiClassificationPerformance(i));
            ++i;
        }
        i = 0;
        while (i < WeightedMultiClassPerformance.NAMES.length) {
            performanceCriteria.add(new WeightedMultiClassPerformance(i));
            ++i;
        }
        i = 0;
        while (i < RankCorrelation.NAMES.length) {
            performanceCriteria.add(new RankCorrelation(i));
            ++i;
        }
        return performanceCriteria;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_CLASS_WEIGHTS, "The weights for all classes (first column: class name, second column: weight), empty: using 1 for all classes.", new ParameterTypeDouble("weight", "The weight for the specified class.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        return types;
    }
}

