/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.PerformanceVectorViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.performance.PerformanceComparator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.AverageVector;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class PerformanceVector
extends AverageVector {
    private static final long serialVersionUID = 3123587140049371098L;
    public static final String MAIN_CRITERION_FIRST = "first";
    private static final String RESULT_ICON_NAME = "percent.png";
    private static Icon resultIcon = null;
    private Map<String, Double> currentValues = null;
    private PerformanceComparator comparator = new DefaultComparator();
    private String mainCriterion = null;

    static {
        resultIcon = SwingTools.createIcon("16/percent.png");
    }

    public void setComparator(PerformanceComparator comparator) {
        this.comparator = comparator;
    }

    public void addCriterion(PerformanceCriterion crit) {
        PerformanceCriterion pc = this.getCriterion(crit.getName());
        if (pc != null) {
            this.removeAveragable(pc);
            LogService.getGlobal().log("Performance criterion '" + crit.getName() + "' was already part of performance vector. Overwritten...", 5);
        }
        this.addAveragable(crit);
    }

    public PerformanceCriterion getCriterion(int index) {
        return (PerformanceCriterion)this.getAveragable(index);
    }

    public PerformanceCriterion getCriterion(String name) {
        return (PerformanceCriterion)this.getAveragable(name);
    }

    public String[] getCriteriaNames() {
        String[] criteriaNames = new String[this.getSize()];
        int i = 0;
        while (i < criteriaNames.length) {
            criteriaNames[i] = this.getCriterion(i).getName();
            ++i;
        }
        return criteriaNames;
    }

    public void setMainCriterionName(String mcName) {
        if (!mcName.equals(MAIN_CRITERION_FIRST) && this.getAveragable(mcName) == null) {
            LogService.getGlobal().log("Main criterion not found: '" + mcName + "'.", 6);
        }
        this.mainCriterion = mcName;
    }

    public PerformanceCriterion getMainCriterion() {
        if (this.mainCriterion == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        PerformanceCriterion pc = (PerformanceCriterion)this.getAveragable(this.mainCriterion);
        if (pc == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        return pc;
    }

    public int compareTo(Object o) {
        double result = this.comparator.compare(this, (PerformanceVector)o);
        if (result < 0.0) {
            return -1;
        }
        if (result > 0.0) {
            return 1;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        PerformanceVector av = new PerformanceVector();
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            av.addAveragable((Averagable)avg.clone());
            ++i;
        }
        return av;
    }

    public Component getVisualizationComponent(IOContainer container) {
        return new PerformanceVectorViewer(this, container);
    }

    public Icon getResultIcon() {
        return resultIcon;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(Tools.getLineSeparator()) + "PerformanceVector [");
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            if (this.mainCriterion != null && avg.getName().equals(this.mainCriterion)) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "*****");
            } else {
                result.append(String.valueOf(Tools.getLineSeparator()) + "-----");
            }
            result.append(avg);
            ++i;
        }
        result.append(String.valueOf(Tools.getLineSeparator()) + "]");
        return result.toString();
    }

    public String getExtension() {
        return "per";
    }

    public String getFileDescription() {
        return "performance vector file";
    }

    public void save(File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            super.write(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void initWriting() {
        this.currentValues = new HashMap<String, Double>();
        int i = 0;
        while (i < this.size()) {
            Averagable averagable = this.getAveragable(i);
            this.currentValues.put(averagable.getName(), averagable.getAverage());
            ++i;
        }
    }

    public static class DefaultComparator
    implements PerformanceComparator {
        private static final long serialVersionUID = 8632060851821885142L;

        public int compare(PerformanceVector av1, PerformanceVector av2) {
            return av1.getMainCriterion().compareTo(av2.getMainCriterion());
        }
    }
}

