/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.RankStatistics;
import com.rapidminer.tools.math.Averagable;

public class RankCorrelation
extends MeasuredPerformance {
    private static final long serialVersionUID = 6908369375703683363L;
    public static final String[] NAMES = new String[]{"spearman_rho", "kendall_tau"};
    public static final String[] DESCRIPTIONS = new String[]{"The rank correlation between the actual and predicted labels, using Spearman's rho.", "The rank correlation between the actual and predicted labels, using Kendall's tau-b."};
    public static final int RHO = 0;
    public static final int TAU = 1;
    private double counter = 0.0;
    private double value = Double.NaN;
    private int type = 0;

    public RankCorrelation() {
        this(0);
    }

    public RankCorrelation(int type) {
        this.type = type;
    }

    public RankCorrelation(RankCorrelation rc) {
        super(rc);
        this.type = rc.type;
        this.value = rc.value;
        this.counter = rc.counter;
    }

    public void countExample(Example example) {
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public double getExampleCount() {
        return this.counter;
    }

    public double getFitness() {
        return this.getMikroAverage();
    }

    protected void buildSingleAverage(Averagable averagable) {
        RankCorrelation other = (RankCorrelation)averagable;
        this.counter += other.counter;
        this.value += other.value;
    }

    public double getMikroAverage() {
        return this.value;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.counter = eSet.size();
        this.value = this.type == 0 ? RankStatistics.rho(eSet, eSet.getAttributes().getLabel(), eSet.getAttributes().getPredictedLabel()) : RankStatistics.tau_b(eSet, eSet.getAttributes().getLabel(), eSet.getAttributes().getPredictedLabel());
    }
}

