/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbsoluteError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.CorrelationCriterion;
import com.rapidminer.operator.performance.LenientRelativeError;
import com.rapidminer.operator.performance.NormalizedAbsoluteError;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PredictionAverage;
import com.rapidminer.operator.performance.RankCorrelation;
import com.rapidminer.operator.performance.RelativeError;
import com.rapidminer.operator.performance.RootMeanSquaredError;
import com.rapidminer.operator.performance.RootRelativeSquaredError;
import com.rapidminer.operator.performance.SquaredCorrelationCriterion;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.operator.performance.StrictRelativeError;
import com.rapidminer.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{RootMeanSquaredError.class, AbsoluteError.class, RelativeError.class, LenientRelativeError.class, StrictRelativeError.class, NormalizedAbsoluteError.class, RootRelativeSquaredError.class, SquaredError.class, CorrelationCriterion.class, SquaredCorrelationCriterion.class, PredictionAverage.class};

    public RegressionPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNumerical()) {
            throw new UserError((Operator)this, 102, "the calculation of performance criteria for regression tasks", label.getName());
        }
    }

    @Override
    protected double[] getClassWeights(Attribute label) {
        return null;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        LinkedList<PerformanceCriterion> allCriteria = new LinkedList<PerformanceCriterion>();
        int i = 0;
        while (i < SIMPLE_CRITERIA_CLASSES.length) {
            try {
                allCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            ++i;
        }
        i = 0;
        while (i < RankCorrelation.NAMES.length) {
            allCriteria.add(new RankCorrelation(i));
            ++i;
        }
        return allCriteria;
    }
}

