/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.viewer.ConfusionMatrixViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.ClassWeightedPerformance;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WeightedMultiClassPerformance
extends MeasuredPerformance
implements ClassWeightedPerformance {
    private static final long serialVersionUID = 8734250559680229116L;
    public static final int UNDEFINED = -1;
    public static final int WEIGHTED_RECALL = 0;
    public static final int WEIGHTED_PRECISION = 1;
    public static final String[] NAMES = new String[]{"weighted_mean_recall", "weighted_mean_precision"};
    public static final String[] DESCRIPTIONS = new String[]{"The weighted mean of all per class recall measurements.", "The weighted mean of all per class precision measurements."};
    private double[][] counter;
    private String[] classNames;
    private Map<String, Integer> classNameMap = new HashMap<String, Integer>();
    private int type = 0;
    private double[] classWeights;
    private double weightSum;
    private Attribute labelAttribute;
    private Attribute predictedLabelAttribute;
    private Attribute weightAttribute;

    public WeightedMultiClassPerformance() {
        this(-1);
    }

    public WeightedMultiClassPerformance(int type) {
        this.type = type;
    }

    public WeightedMultiClassPerformance(WeightedMultiClassPerformance m) {
        super(m);
        this.type = m.type;
        this.classNames = new String[m.classNames.length];
        int i = 0;
        while (i < this.classNames.length) {
            this.classNames[i] = m.classNames[i];
            this.classNameMap.put(this.classNames[i], i);
            ++i;
        }
        this.counter = new double[m.counter.length][m.counter.length];
        i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                this.counter[i][j] = m.counter[i][j];
                ++j;
            }
            ++i;
        }
        this.labelAttribute = (Attribute)m.labelAttribute.clone();
        this.predictedLabelAttribute = (Attribute)m.predictedLabelAttribute.clone();
        if (m.weightAttribute != null) {
            this.weightAttribute = (Attribute)m.weightAttribute.clone();
        }
    }

    public static WeightedMultiClassPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new WeightedMultiClassPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public void setWeights(double[] weights) {
        this.weightSum = 0.0;
        double[] dArray = this.classWeights = weights;
        int n = this.classWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            this.weightSum += w;
            ++n2;
        }
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.labelAttribute = eSet.getAttributes().getLabel();
        if (!this.labelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", this.labelAttribute.getName());
        }
        this.predictedLabelAttribute = eSet.getAttributes().getPredictedLabel();
        if (this.predictedLabelAttribute == null || !this.predictedLabelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", "predicted label attribute");
        }
        if (useExampleWeights) {
            this.weightAttribute = eSet.getAttributes().getWeight();
        }
        List<String> values = this.labelAttribute.getMapping().getValues();
        this.counter = new double[values.size()][values.size()];
        this.classNames = new String[values.size()];
        Iterator i = values.iterator();
        int n = 0;
        while (i.hasNext()) {
            this.classNames[n] = (String)i.next();
            this.classNameMap.put(this.classNames[n], n);
            ++n;
        }
    }

    public void countExample(Example example) {
        int label = this.classNameMap.get(example.getNominalValue(this.labelAttribute));
        int plabel = this.classNameMap.get(example.getNominalValue(this.predictedLabelAttribute));
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double[] dArray = this.counter[label];
        int n = plabel;
        dArray[n] = dArray[n] + weight;
    }

    public double getExampleCount() {
        double total = 0.0;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        return total;
    }

    public double getMikroAverage() {
        switch (this.type) {
            case 0: {
                double[] columnSums = new double[this.classNames.length];
                int c = 0;
                while (c < columnSums.length) {
                    int r = 0;
                    while (r < this.counter[c].length) {
                        int n = c;
                        columnSums[n] = columnSums[n] + this.counter[c][r];
                        ++r;
                    }
                    ++c;
                }
                double result = 0.0;
                int c2 = 0;
                while (c2 < columnSums.length) {
                    double r = this.counter[c2][c2] / columnSums[c2];
                    result += this.classWeights[c2] * (Double.isNaN(r) ? 0.0 : r);
                    ++c2;
                }
                return result /= this.weightSum;
            }
            case 1: {
                double[] rowSums = new double[this.classNames.length];
                int r = 0;
                while (r < this.counter.length) {
                    int c = 0;
                    while (c < this.counter[r].length) {
                        int n = r;
                        rowSums[n] = rowSums[n] + this.counter[c][r];
                        ++c;
                    }
                    ++r;
                }
                double result = 0.0;
                r = 0;
                while (r < rowSums.length) {
                    double p = this.counter[r][r] / rowSums[r];
                    result += this.classWeights[r] * (Double.isNaN(p) ? 0.0 : p);
                    ++r;
                }
                return result /= this.weightSum;
            }
        }
        throw new RuntimeException("Unknown type " + this.type + " for weighted multi class performance criterion!");
    }

    public boolean formatPercent() {
        return true;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public double getFitness() {
        return this.getAverage();
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void buildSingleAverage(Averagable performance) {
        WeightedMultiClassPerformance other = (WeightedMultiClassPerformance)performance;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                double[] dArray = this.counter[i];
                int n = j;
                dArray[n] = dArray[n] + other.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    private String toWeightString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(", weights: ");
        boolean first = true;
        double[] dArray = this.classWeights;
        int n = this.classWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            if (!first) {
                result.append(", ");
            }
            result.append(Tools.formatIntegerIfPossible(w));
            first = false;
            ++n2;
        }
        return result.toString();
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        return new ConfusionMatrixViewer(this.toWeightString(), this.classNames, this.counter);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(this.toWeightString()));
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        int i = 0;
        while (i < this.counter.length) {
            result.append("\t" + this.classNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.counter.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + this.classNames[i] + ":");
            int j = 0;
            while (j < this.counter[i].length) {
                result.append("\t" + Tools.formatIntegerIfPossible(this.counter[j][i]));
                ++j;
            }
            ++i;
        }
        return result.toString();
    }
}

