/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueReplace
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_REPLACE_WHAT = "replace_what";
    public static final String PARAMETER_REPLACE_BY = "replace_by";
    public static final String PARAMETER_APPLY_ON_SPECIAL = "apply_on_special";

    public AttributeValueReplace(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String regex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        if (this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL)) {
            i = exampleSet.getAttributes().allAttributes();
        }
        LinkedList<Attribute> matchingAttributes = new LinkedList<Attribute>();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (matcher.matches()) {
                if (attribute.isNominal()) {
                    matchingAttributes.add(attribute);
                } else {
                    this.logWarning("Cannot replace substring for non-nominal attribute '" + attribute.getName() + "', skipping...");
                }
            }
            this.checkForStop();
        }
        String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
        String replaceBy = "";
        if (this.isParameterSet(PARAMETER_REPLACE_BY)) {
            replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
        }
        for (Attribute attribute : matchingAttributes) {
            Attribute newAttribute = this.createReplacedAttribute(exampleSet, attribute, replaceWhat, replaceBy);
            AttributeRole role = exampleSet.getAttributes().getRole(attribute);
            exampleSet.getAttributes().remove(attribute);
            newAttribute.setName(attribute.getName());
            if (!role.isSpecial()) continue;
            String specialName = role.getSpecialName();
            exampleSet.getAttributes().setSpecialAttribute(newAttribute, specialName);
        }
        return exampleSet;
    }

    private Attribute createReplacedAttribute(ExampleSet exampleSet, Attribute originalAttribute, String replaceWhat, String replaceBy) {
        Attribute newAttribute = AttributeFactory.createAttribute(1);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        newAttribute.setConstruction("replace(" + originalAttribute.getName() + "," + replaceWhat + "," + replaceBy + ")");
        Pattern whatPattern = Pattern.compile(replaceWhat);
        for (Example example : exampleSet) {
            double value = example.getValue(originalAttribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            String stringValue = originalAttribute.getMapping().mapIndex((int)value);
            Matcher whatMatcher = whatPattern.matcher(stringValue);
            String newValue = whatMatcher.replaceAll(replaceBy);
            if (newValue.length() == 0) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            example.setValue(newAttribute, newAttribute.getMapping().mapString(newValue));
        }
        return newAttribute;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_ATTRIBUTES, "Substring creation of values will be applied to the attributes that match the given regular expression.", false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_REPLACE_WHAT, "The substring which should be replaced.", false));
        types.add(new ParameterTypeString(PARAMETER_REPLACE_BY, "The new substring which should replace the old one.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_SPECIAL, "Filter also special attributes (label, id...)", false));
        return types;
    }
}

