/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date2Nominal
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static List<Locale> availableLocales;
    public static String[] availableLocaleNames;
    public static int defaultLocale;

    static {
        Locale[] availableLocaleArray;
        availableLocales = new ArrayList<Locale>();
        Locale[] localeArray = availableLocaleArray = Locale.getAvailableLocales();
        int n = availableLocaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            availableLocales.add(l);
            ++n2;
        }
        Collections.sort(availableLocales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        availableLocaleNames = new String[availableLocales.size()];
        defaultLocale = -1;
        int i = 0;
        while (i < availableLocales.size()) {
            Locale currentLocale = availableLocales.get(i);
            Date2Nominal.availableLocaleNames[i] = currentLocale.getDisplayName();
            if (currentLocale.equals(Locale.US)) {
                defaultLocale = i;
            }
            ++i;
        }
        if (defaultLocale < 0) {
            defaultLocale = 0;
        }
    }

    public Date2Nominal(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        Attribute newAttribute = AttributeFactory.createAttribute(1);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        Locale selectedLocale = Locale.US;
        if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
            selectedLocale = availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
        }
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat, selectedLocale);
        for (Example example : exampleSet) {
            if (Double.isNaN(example.getValue(dateAttribute))) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            Date date = new Date((long)example.getValue(dateAttribute));
            String newDateStr = parser.format(date);
            example.setValue(newAttribute, newAttribute.getMapping().mapString(newDateStr));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(String.valueOf(attributeName) + "_nominal");
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", false));
        types.add(new ParameterTypeString(PARAMETER_DATE_FORMAT, "The output format of the date values, for example \"yyyy/MM/dd\".", false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", availableLocaleNames, defaultLocale);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }
}

