/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary
extends PreprocessingModel {
    private static final long serialVersionUID = 1441613108993813785L;
    private List<String[]> replacements;
    private boolean regexp = false;
    private boolean toLowerCase = false;

    public Dictionary(boolean regexp, ExampleSet exampleSet, List<String[]> replacements, boolean toLowerCase) {
        super(exampleSet);
        this.regexp = regexp;
        this.replacements = replacements;
        this.toLowerCase = toLowerCase;
    }

    private void remap(Attributes attributes) {
        for (Attribute attr : attributes) {
            if (!attr.isNominal()) continue;
            NominalMapping mapping = attr.getMapping();
            for (String string : mapping.getValues()) {
                int index = mapping.getIndex(string);
                mapping.setMapping(this.replace(string), index);
            }
        }
    }

    private String replace(String string) {
        if (this.toLowerCase) {
            string = string.toLowerCase();
        }
        for (String[] replacement : this.replacements) {
            int pos;
            if (this.regexp) {
                string = string.replaceAll(replacement[0], replacement[1]);
                continue;
            }
            StringBuilder soFar = new StringBuilder("");
            String remainder = string;
            while ((pos = remainder.indexOf(replacement[0])) != -1) {
                soFar.append(remainder.substring(0, pos));
                soFar.append(replacement[1]);
                remainder = remainder.substring(pos + replacement[0].length());
            }
            soFar.append(remainder);
            string = soFar.toString();
        }
        return string;
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        this.remap(exampleSet.getAttributes());
        return exampleSet;
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        Attributes attributes = (Attributes)viewParent.getAttributes().clone();
        this.remap(attributes);
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        return value;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (String[] replacement : this.replacements) {
            b.append(replacement[0]);
            b.append(" -> ");
            b.append(replacement[1]);
            b.append("\n");
        }
        return b.toString();
    }
}

