/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.filter.Dictionary;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetToDictionary
extends PreprocessingOperator {
    private static final String PARAMETER_REGEXP = "use_regular_expressions";
    private static final String PARAMETER_TO_LOWERCASE = "convert_to_lwoercase";
    private static final String PARAMETER_FROM_ATTRIBUTE = "from_attribute";
    private static final String PARAMETER_TO_ATTRIBUTE = "to_attribute";

    public ExampleSetToDictionary(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        ExampleSet dictionary = this.getInput(ExampleSet.class);
        boolean toLowerCase = this.getParameterAsBoolean(PARAMETER_TO_LOWERCASE);
        if (dictionary.getAttributes().size() != 2) {
            throw new UserError((Operator)this, 133, 2, dictionary.getAttributes().size());
        }
        LinkedList<String[]> replacements = new LinkedList<String[]>();
        Attribute from = dictionary.getAttributes().get(this.getParameterAsString(PARAMETER_FROM_ATTRIBUTE));
        Attribute to = dictionary.getAttributes().get(this.getParameterAsString(PARAMETER_TO_ATTRIBUTE));
        if (!from.isNominal()) {
            throw new UserError((Operator)this, 119, from.getName(), this);
        }
        if (!to.isNominal()) {
            throw new UserError((Operator)this, 119, to.getName(), this);
        }
        for (Example example : dictionary) {
            if (toLowerCase) {
                replacements.add(new String[]{example.getValueAsString(from).toLowerCase(), example.getValueAsString(to).toLowerCase()});
                continue;
            }
            replacements.add(new String[]{example.getValueAsString(from), example.getValueAsString(to)});
        }
        return new Dictionary(this.getParameterAsBoolean(PARAMETER_REGEXP), exampleSet, replacements, toLowerCase);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_REGEXP, "Choose whether the replacements are treated as regular expressions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_TO_LOWERCASE, "Choose whether the strings are converted to lower case.", false));
        types.add(new ParameterTypeString(PARAMETER_FROM_ATTRIBUTE, "Name of the attribute that specifies what is replaced.", "from"));
        types.add(new ParameterTypeString(PARAMETER_TO_ATTRIBUTE, "Name of the attribute that specifies replacements.", "to"));
        return types;
    }
}

