/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRangeRemoval
extends AbstractFeatureSelection {
    public static final String PARAMETER_FIRST_ATTRIBUTE = "first_attribute";
    public static final String PARAMETER_LAST_ATTRIBUTE = "last_attribute";

    public FeatureRangeRemoval(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int first = this.getParameterAsInt(PARAMETER_FIRST_ATTRIBUTE) - 1;
        int last = this.getParameterAsInt(PARAMETER_LAST_ATTRIBUTE) - 1;
        if (last < first) {
            this.logWarning("Last attribute is smaller than first. No change performed.");
        }
        if (last >= exampleSet.getAttributes().size()) {
            throw new UserError((Operator)this, 125, String.valueOf(exampleSet.getAttributes().size()), String.valueOf(last + 1));
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        int counter = 0;
        while (i.hasNext() && counter <= last) {
            i.next();
            if (counter >= first && counter <= last) {
                i.remove();
            }
            this.checkForStop();
            ++counter;
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameterTypes = super.getParameterTypes();
        ParameterTypeInt parameterType = new ParameterTypeInt(PARAMETER_FIRST_ATTRIBUTE, "The first attribute of the attribute range which should  be removed", 1, Integer.MAX_VALUE, false);
        parameterType.setExpert(false);
        parameterTypes.add(parameterType);
        parameterType = new ParameterTypeInt(PARAMETER_LAST_ATTRIBUTE, "The last attribute of the attribute range which should  be removed", 1, Integer.MAX_VALUE, false);
        parameterType.setExpert(false);
        parameterTypes.add(parameterType);
        return parameterTypes;
    }
}

